<?php
class SppMessageController extends AppController {

	var $name = 'SppMessage';
	var $uses = array('SppMessage', 'SppUser', "SppUserRole", 'SppRole', 'SppDeviceToken');
	var $helpers = array('Html', 'Form', 'Session', 'Dialog');
	var $components = array('Auth', 'Session');
	
	function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow('index', 'submitMessage', 'check');
		// Load config file
		Configure::load('settings');	
	
		// check session and role
		if(!$this->isSupporter()){
			$this->render('/elements/error');
			return;
		}	
    }
	
	
	function index() {
		
		$currentUser = $this->Auth->user();
		$roles = $this->getUserRole($currentUser['SppUser']['id']);
				
		$this->set('roles', $roles);
		$messages = $this->SppMessage->find('all', array('order'=>'SppMessage.created_datetime DESC', 'limit'=>5));
		$this->set("messages", $messages);
        if($this->Session->read('PUSH.FILEERROR')!=null){
			$this->set("pushError", $this->Session->read('PUSH.FILEERROR'));
			$this->Session->delete('PUSH.FILEERROR');
        }
        $this->set('fullurl', FULL_BASE_URL . $this->webroot);
	}
	
	function submitMessage() {
		
		if(!empty($this->data)) {
			$this->SppMessage->create();
			// push 
			$success = 0;
			$fail = 0;
			$deviceToken = $this->SppDeviceToken->find('all');
			$message = $this->data['SppMessage']['message'];
			foreach ($deviceToken as $val){
					$tokenId = $val['SppDeviceToken']['device_id'];
					if($val['SppDeviceToken']['device_type'] == 1){
						if($this->_pushMessage($message, $tokenId)){
							$success++;
						}
						else{
							$fail++;
						}	
					} else {
						if($this->_androidPush($message, $tokenId)){
							$success++;
						} else {
							$fail++;
						}				
					}
			}
			//End push
			
			$this->data['SppMessage']['created_datetime'] = date('Y-m-d H:i:s');
			$this->data['SppMessage']['success'] = $success;
			$this->data['SppMessage']['fail'] = $fail;
			
			
			$this->SppMessage->begin();
			try{
				if ($this->SppMessage->save($this->data)) {
					$this->SppMessage->commit();
					$this->redirect(array('action'=>'index'));
				}	
			} catch (Exception $e) {
				$this->SppContent->rollback();
			}
		}
	}
	
	function check() {
		Configure::write('debug', 1);
		$this->layout = 'ajax';
		$this->autoRender = false;
		
		//$msg = Configure::read('Message.ERR_PUSH_MESSAGE_LENGTH');
		if(!empty($_POST['msg'])) {
			return strlen($_POST['msg']);
		} else {
			return 0;	
		}	
	}
	
	function _pushMessage($message, $deviceToken){
		// Put your device token here (without spaces):
		//$deviceToken = '40e67dd6b87f91f6de4d3b6fe01cd5a7e3c72770bb0d5cbb12842dccb2a3a613';
		//Put your private key's passphrase here:
		//$passphrase = 'tuan123';
		$passphrase = Configure::read('Push.passphrase');
		// Put your alert message here:
		if(!isset($message) || $message ==null)
		{
			//$this->Pass4v->errorResponse(Configure::read('errorNoContentInfo'),"", $xml);
			return false;
		}

		////////////////////////////////////////////////////////////////////////////////

		$ctx = stream_context_create();
		$certificate =  Configure::read('Push.certpath');
		stream_context_set_option($ctx, 'ssl', 'local_cert', $certificate);
		stream_context_set_option($ctx, 'ssl', 'passphrase', $passphrase);
		
		// Open a connection to the APNS server
		$fp = stream_socket_client(
			Configure::read('Push.apns'), $err,
			$errstr, 60, STREAM_CLIENT_CONNECT|STREAM_CLIENT_PERSISTENT, $ctx);
		
		if (!$fp){
			$this->Session->write('PUSH.FILEERROR', 'PEMファイルが存在しません、またはPEMファイルがエラーになります。');
			return;
		}
		// Create the payload body
		$body['aps'] = array(
			'alert' => $message,
			'sound' => 'default'
			);
		
		// Encode the payload as JSON
		$payload = json_encode($body);
		
		// Build the binary notification
		$msg = chr(0) . pack('n', 32) . pack('H*', $deviceToken) . pack('n', strlen($payload)) . $payload;
		
		// Send it to the server
		if (!$result = fwrite($fp, $msg, strlen($msg)))
			return false;
		else
			return true;
		
		// Close the connection to the server
		fclose($fp);
		return false;
	}
	
	/**
	 * Author: TuanNM
	 * Date: 2013/03/05
	 * Push message to Android device
	 * @param $message
	 * @param $deviceToken
	 */
	function _androidPush($message, $deviceToken){
		//request url
		$url = Configure::read('Push.android');
		 
		//your api key
		$apiKey = Configure::read('Push.androidapikey');
		 
		//registration ids
		$registrationIDs = array($deviceToken);
		 
		//payload data
		$data   = array('message' => $message);
		 
		$fields = array('registration_ids' => $registrationIDs,
		                'data' => $data);
		 
		//http header
		$headers = array('Authorization: key=' . $apiKey,
		                 'Content-Type: application/json');
		 
		//curl connection
		$ch = curl_init();
		 
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
		 
		$result = curl_exec($ch);
		 
		curl_close($ch);
		
		$result = json_decode($result, true);
		if($result['success'] == 1){
			return true;
		} else {
			return false;
		}
	}

}
?>