<?php
class SppLearningLog extends AppModel {
	var $name = "SppLearningLog";
	var $actsAs   = array('Transactional');

	function saveData($learner_id, $learning_log){
		
		if($learner_id != "" && $learning_log['time_start'] != "" && $learning_log['time_end'] != "" ){
			$time_start_str = $learning_log['time_start'];
			$time_start_datetime = date('Y-m-d H:i:s', strtotime($time_start_str));
			
			$time_end_str = $learning_log['time_end'];
			$time_end_datetime = date('Y-m-d H:i:s', strtotime($time_end_str));
			
$startedOn = new DateTimeImmutable($time_start_datetime);
$finishedOn = new DateTimeImmutable($time_end_datetime);
$durationInSeconds = $finishedOn->getTimestamp() - $startedOn->getTimestamp();

			$learning_log_temp = $this->find('first',array('conditions'=>array('learner_id' => $learner_id,
		   																	'time_start' => $time_start_datetime, 
		   																	'time_end' => $time_end_datetime)));
			$illegal = false;
			$last_log = $this->find('first',array('conditions'=>array('learner_id' => $learner_id),
													'order' => 'time_end DESC',
													'limit' => '1' ));
			if(!empty($last_log)){
				$last_log_time_end = date('Y-m-d H:i:s', strtotime($last_log['SppLearningLog']['time_end']));
				if($last_log_time_end > $time_start_datetime){
					$illegal = true;
				}
			}
			if(empty($learning_log_temp) && !$illegal){
				$this->create();
				$this->set(array('learner_id' => $learner_id,
								 'time_start' => $learning_log['time_start'],
								 'time_end' => $learning_log['time_end'],
								 'learning_date' => $learning_log['date'],
//								 'learning_duration' => $learning_log['duration'],
'learning_duration' => $durationInSeconds,
								 'insert_datetime' => date("y-m-d H:i:s")));
				if(!$this->save()){
					return false;
				}
			}
		}
		return true;
	}
}