<?php
class SppQuizLog extends AppModel {
	var $name 		= 'SppQuizLog';
	//var $Pass4v;
	
	function getData(){
		return $this->find('first');
	}
	
	function getData2(){
		return $this->find('all', 
			array(
				'conditions' => array(
					'NOT' => array(
						'desc_answer' => NULL)
				)
			)
		);
	}
	
	function getData3($learner_id, $first_name, $last_name){

		//$conditions = array();
		$conditions = array(
			'NOT' => array(
				'desc_answer' => NULL)
		);
		$fields = "";
		$joins = array();

		$joins[]= array(
			'table' => 'spp_learners',
			'alias' => 'SppLearner',
			'type' => 'inner',
			'conditions' => array('SppLearner.id = SppQuizLog.learner_id')
		);
		
		if(!empty($learner_id)){
			$conditions[] = "SppLearner.email LIKE '%".$learner_id."%'";
		}
		if(!empty($first_name)){
			$conditions['OR']= array("SppLearner.first_name LIKE '%".$first_name."%'", "SppLearner.first_name_kana LIKE '%".$first_name."%'" );
		}
		if(!empty($last_name)){
			$conditions['OR']= array("SppLearner.last_name LIKE '%".$last_name."%'", "SppLearner.last_name_kana LIKE '%".$last_name."%'" );
		}

		$fields = "SppQuizLog.*, SppLearner.organization_code, SppLearner.first_name, SppLearner.last_name, SppLearner.email";

		return array(
			'fields' => $fields,
			'limit' => Configure::read('STUDY_RECORD.NUMBER_OF_PAGE'),
			'conditions' => $conditions,
			'joins' => $joins,
			'order' => 'SppLearner.email'
		);
	}

	function getData3csv($learner_id, $first_name, $last_name){

		//$conditions = array();
		$conditions = array(
			'NOT' => array(
				'desc_answer' => NULL)
		);
		$fields = "";
		$joins = array();

		$joins[]= array(
			'table' => 'spp_learners',
			'alias' => 'SppLearner',
			'type' => 'inner',
			'conditions' => array('SppLearner.id = SppQuizLog.learner_id')
		);
		
		if(!empty($learner_id)){
			$conditions[] = "SppLearner.email LIKE '%".$learner_id."%'";
		}
		if(!empty($first_name)){
			$conditions['OR']= array("SppLearner.first_name LIKE '%".$first_name."%'", "SppLearner.first_name_kana LIKE '%".$first_name."%'" );
		}
		if(!empty($last_name)){
			$conditions['OR']= array("SppLearner.last_name LIKE '%".$last_name."%'", "SppLearner.last_name_kana LIKE '%".$last_name."%'" );
		}

		$fields = "SppQuizLog.*, SppLearner.organization_code, SppLearner.first_name, SppLearner.last_name, SppLearner.email";

		$arr = array(
			'fields' => $fields,
			'conditions' => $conditions,
			'joins' => $joins,
			'order' => 'SppLearner.email'
		);
		return $this->find('all', $arr);
	}
	
	function saveData($learner_id, $quiz_log){
		$this->log('saveData',LOG_DEBUG);
		if($quiz_log['content_id'] != "" && $quiz_log['category_no'] != "" && $quiz_log['subcategory_no'] != "" &&
		   $quiz_log['quiz_no'] != "" && $quiz_log['answer'] != ""){
			$this->log('learner_id: '.$learner_id,LOG_DEBUG);
			$this->log('quiz_log:',LOG_DEBUG);
			$this->log($quiz_log,LOG_DEBUG);
		   	$quiz_log_temp = $this->find('first',array('conditions'=>array('learner_id'=>$learner_id,
		   								'content_id'=>$quiz_log['content_id'], 'category_no'=>$quiz_log['category_no'],
										'subcategory_no'=>$quiz_log['subcategory_no'], 'quiz_no'=>$quiz_log['quiz_no'])));
			//$this->Pass4v->response($quiz_log_temp);
			$this->log('quiz_log_temp:',LOG_DEBUG);
			$this->log($quiz_log_temp,LOG_DEBUG);
				
			   	if(!empty($quiz_log_temp)){
			$this->log('not empty',LOG_DEBUG);
					$try_count = ($quiz_log_temp['SppQuizLog']['try_count'] <$quiz_log['try_count'])?$quiz_log['try_count']:$quiz_log_temp['SppQuizLog']['try_count'];
					$incorrect_count = ($quiz_log_temp['SppQuizLog']['incorrect_count'] <$quiz_log['incorrect_count'])?$quiz_log['incorrect_count']:$quiz_log_temp['SppQuizLog']['incorrect_count'];

			   		$quiz_log_temp['SppQuizLog']['last_answer'] = $quiz_log['last_answer'];
			   		$quiz_log_temp['SppQuizLog']['answer'] = $quiz_log['answer'];
			   		//$quiz_log_temp['SppQuizLog']['try_count'] = $quiz_log['try_count'];
			   		$quiz_log_temp['SppQuizLog']['try_count'] = $try_count;;
			   		//$quiz_log_temp['SppQuizLog']['incorrect_count'] = $quiz_log['incorrect_count'];
			   		$quiz_log_temp['SppQuizLog']['incorrect_count'] = $incorrect_count;
			   		$quiz_log_temp['SppQuizLog']['selectbox'] = (isset($quiz_log['selectbox']) && $quiz_log['selectbox'] == 1) ? 1 : 0;
			   		$quiz_log_temp['SppQuizLog']['face_marks'] = $quiz_log['face_marks'] ? $quiz_log['face_marks'] : null;
			   		$quiz_log_temp['SppQuizLog']['category_name'] = $quiz_log['category_name'];
			   		$quiz_log_temp['SppQuizLog']['subcategory_name'] = $quiz_log['subcategory_name'];
			   		$quiz_log_temp['SppQuizLog']['desc_answer'] = $quiz_log['desc_answer'];
			   		$quiz_log_temp['SppQuizLog']['desc_answer_date'] = $quiz_log['desc_answer_date'];
			   		if($this->save($quiz_log_temp)){
			   			return true;
			   		}
			   		return false;
			   	}else{
			$this->log('empty',LOG_DEBUG);
			$this->log('learner_id: '.$learner_id,LOG_DEBUG);
			$this->log('content_id: '.$quiz_log['content_id'],LOG_DEBUG);
			$this->log('category_no: '.$quiz_log['category_no'],LOG_DEBUG);
			//$this->log('category_name: '.(isset($quiz_log['category_name'])) ? $quiz_log['category_name'] : null,LOG_DEBUG);
			$this->log('subcategory_no: '.$quiz_log['subcategory_no'],LOG_DEBUG);
			//$this->log('subcategory_name: '.(isset($quiz_log['subcategory_name'])) ? $quiz_log['subcategory_name'] : null,LOG_DEBUG);
			$this->log('quiz_no: '.$quiz_log['quiz_no'],LOG_DEBUG);
			$this->log('last_answer: '.$quiz_log['last_answer'],LOG_DEBUG);
			$this->log('answer: '.$quiz_log['answer'],LOG_DEBUG);
			$this->log('selectbox: '.(isset($quiz_log['selectbox']) && $quiz_log['selectbox'] == 1) ? 1 : 0,LOG_DEBUG);
			//$this->log('face_marks: '.$quiz_log['face_marks'] ? $quiz_log['face_marks'] : null,LOG_DEBUG);
			$this->log('try_count: '.$quiz_log['try_count'],LOG_DEBUG);
			$this->log('incorrect_count: '.$quiz_log['incorrect_count'],LOG_DEBUG);
			$this->log('insert_date: '.date('Y-m-d H:i:s'),LOG_DEBUG);
			//$this->log('desc_answer: '.$quiz_log['desc_answer'],LOG_DEBUG);
			//$this->log('desc_answer_date: '.$quiz_log['desc_answer_date'],LOG_DEBUG);
			   		$this->create();
			   		$this->set(array(
										'learner_id' => $learner_id,
										'content_id' => $quiz_log['content_id'],
										'category_no' => $quiz_log['category_no'],
										'category_name' => $quiz_log['category_name'],
										//'category_name' => 'category_name',
										'subcategory_no' => $quiz_log['subcategory_no'],
										'subcategory_name' => $quiz_log['subcategory_name'],
										//'subcategory_name' => 'subcategory_name',
										'quiz_no' => $quiz_log['quiz_no'],
										'last_answer' => $quiz_log['last_answer'],
										'answer' => $quiz_log['answer'],
										'selectbox' => (isset($quiz_log['selectbox']) && $quiz_log['selectbox'] == 1) ? 1 : 0,
										//'face_marks' => $quiz_log['face_marks'] ? $quiz_log['face_marks'] : null,
										'try_count' => $quiz_log['try_count'],
										'incorrect_count' => $quiz_log['incorrect_count'],
										//'insert_date' => date('Y-m-d H:i:s')));
										'insert_date' => date('Y-m-d H:i:s'),
										'desc_answer' => $quiz_log['desc_answer'],
										'desc_answer_date' => $quiz_log['desc_answer_date']
					));
					$this->log('save',LOG_DEBUG);
			   		if($this->save()){
						$this->log('save:true',LOG_DEBUG);
			   			return true;
			   		}
					$this->log('save:false',LOG_DEBUG);
			   		return false;
			   	}
		   }
		   return true;
	}
	
	function quizLogStatistic($learner_id){
		//return $this->find('first', array('fields' => array('COUNT(*) AS all_try_count', 
		//									 'COUNT(CASE WHEN last_answer = 0 THEN 1 END ) AS all_miss_count'),
		//						   'conditions' => array('learner_id' => $learner_id)));
		return $this->find('first', array('fields' => array('SUM(try_count) AS all_try_count', 
											 'SUM(incorrect_count) AS all_miss_count'),
								   'conditions' => array('learner_id' => $learner_id)));
	}
}
