<?php // $Id$
/**
 * @copyright     2011 (c) SEVENSEAS TECHWORKS Co., Ltd. All Rights Reserved.
 * @package       pass4v
 * @since         2011-07-14
 * We use CakePHP(tm) ver 1.3.9
 */

class Pass4vHelper extends AppHelper {

    /**
     * get expire date string
     *
     * @param boolean $nochache defalut true
     * @return string           expire date string "-1", if $nochache set false then return formatted date string
     */
    function getExpireDate($nochache=true)
    {
        // no chache
        $nochache ? $expiredate = "-1" : $expiredate = date('r', (time() + 86400));
        return $expiredate;
    }

    /**
     * get contents author string
     *
     * @param boolean $useSupportMailAddr   defalut false, if true return support mail address
     * @return string                       corporate name or support mail address string
     */
    function getAuthor($useSupportMailAddr=false)
    {
        $useSupportMailAddr ? $ret = Configure::read('supportMailAddr') : $ret = Configure::read('corporateName');
        return $ret;
    }

    /**
     * get copyright string
     *
     * @return string   copyright string
     */
    function getCopyright()
    {
        return Configure::read('copyrightString');
    }

}
?>