<meta name=viewport content="width=device-width, initial-scale=1">
<head>
<?php echo $this->Html->charset(); ?>
<title>ユーザ登録</title>
<?php
echo $this->Html->meta('icon');
echo $this->Html->css('style.css?v=1');
echo $this->Html->css('jquery-ui-1.8.16.custom');
echo $this->Html->css('bootstrap.min');
echo $javascript->link('jquery-1.9.1.min');
echo $javascript->link('jquery-ui-1.8.16.custom.min.js');
echo $javascript->link('jquery.form');
echo $javascript->link('jquery.confirm.min');
echo $javascript->link('app');
echo $javascript->link('bootstrap.min');
echo $javascript->link('run_prettify');
?>
</head>
<style>
div.lbtitle {
	width: 100%;
	float: none !important;
	margin-bottom: 3px;
}

div.comment {
	color: gray;
	font-size: 14px;
	margin: 0 0 5px 115px;
}

div.comment label {
	margin-top: -12px;
	font-weight: normal;
}

.form-group {
	height: auto;
	min-height: 30px;
}

.error-msg {
	color: red;
	margin: 3px 0 10px 120px;
	display: none;
}
</style>
<script type="text/javascript">
$(function() {
	$("#submit_click").click(function(e) {
		e.preventDefault();
	    $.confirm({
	        text: "登録します。よろしいですか。",
	        confirm: function(button) {
		        if(validation()){
	        	  $('#SppLearnerAddConnectLicenseForm').submit();
		        }
	        },
	        cancel: function(button) {
	            return false;
	        },
	        confirmButton: "OK",
            cancelButton: "キャンセル"
	    });
	});
	
	$("#cancel_btn").click(function(e) {
		e.preventDefault();
	    $.confirm({
	        text: "画面を終了します。よろしいですか。",
	        confirm: function(button) {
	        	window.close();
	        },
	        cancel: function(button) {
	            return false;
	        },
	        confirmButton: "OK",
            cancelButton: "キャンセル"
	    });
	});

	

	$("#submit_cancel").click(function(){
		$('.error-msg').hide();
		$('.msg-error').html('');
		$('#password-invalid-msg').css('color','gray');
		$('.form-group input[type != submit]').val('');
		return false;
	});

	// set value for zone (都道府県) select
	$('#zone_select').val($('#zone_data').val());
});

	function validation(){
		$('.error-msg').hide();
		$('#msg-error').html('');
		// check email input
		var emailObj = $('#SppLearnerEmail');
		if(emailObj != null){
			if(isEmpty(emailObj.val())){
				showErrRequire(emailObj);
				return false;
			}
		} else {
			return false;
		}

		// check password input
		var passwordObj = $('#SppLearnerPassword');
		if(passwordObj != null){
			if(isEmpty(passwordObj.val())){
				showErrRequire(passwordObj);
				return false;
			}
			if(!checkLength(passwordObj.val(), 4, 12)){
				$('#password-invalid-msg').show();
				return false;
			}

		} else {
			return false;
		}
		
		return true;
	}
</script>
<?php if ($is_smart_device) {?>
	<div class="intro">
		<label style="font-weight: bold;">ユーザ登録 </label>
	</div>
<?php } else {?>
	<div class="intro">
		<label style="font-weight: normal;">ユーザ登録 </label>
	</div>
<?php }?>
<div class="clear"></div>

<div>
<?php echo $this->Form->create(null,array('action'=>'add_connect_license','type' => 'post','style' => 'width:200px; margin:0 auto; padding: 10px 0 0 10px'));?>
	<?php echo $this->Form->hidden('organization_code', array('value' =>'000100020003')); ?>
	<div id="msg-error" class="msg-error"
		style="margin-bottom: 15px; text-align: center;">
		<?php  echo $session->flash();?>
	</div>
	<div class="form-group">
		<div class="lbtitle required">メールアドレス</div>
		<?php echo $this->Form->input('email',array('label' => false, 'div'=>false, 'type'=>'text','maxlength'=>100,'style'=>'width:200px')); ?>
		<div class='error-msg required-msg'>メールアドレス は必要です。</div>
		<div class='error-msg email-error-msg'>メールアドレスフォーマットが間違っ</div>
	</div>

	<div class="form-group">
		<div class="lbtitle required">パスワード</div>
		<?php echo $this->Form->input('password',array('label' => false, 'div'=>false, 'type'=>'password','minlength'=>4,'maxlength'=>12,'style'=>'width:200px', 'placeholder'=>'英数字４桁～１２桁')); ?>
		<div class='error-msg required-msg'>パスワード は必要です。</div>
		<div class="error-msg" id="password-invalid-msg">英数字４桁～１２桁</div>
	</div>
	
	<div class="form-group">
		<div class="lbtitle">ライセンス番号 </div>
		<?php echo $this->Form->input('license_code',array('label' => false, 'div'=>false, 'type'=>'text', 'style'=>'width:200px', 'placeholder'=>'数字８桁')); ?>
	</div>

	<div class="form-group">
		<div class="lbtitle">ニックネーム</div>
		<?php echo $this->Form->input('nickname',array('label' => false, 'div'=>false, 'type'=>'text','maxlength'=>10,'style'=>'width:200px', 'placeholder'=>'ランキング表示名')); ?>
	</div>
	<br/>
	<div class="form-group" style="margin-left: -6px; width:250px">
		<a id="cancel_btn" style="margin-right: 10px; text-decoration: blink;">
			<input type="button" class="btn-custom cancelBtn">
		</a>
		<a href="javascript:void(0)" id="submit_click">
			<input type="submit" value="" class="btn-custom registerBtn">
		</a>
	</div>
	<?php echo $this->Form->end();?>
</div>

