-- phpMyAdmin SQL Dump
-- version 3.4.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Generation Time: Dec 27, 2012 at 01:59 午後
-- Server version: 5.5.16
-- PHP Version: 5.3.8

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `spp_5`
--

-- --------------------------------------------------------

--
-- Table structure for table `dl_totals`
--

CREATE TABLE IF NOT EXISTS `dl_totals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` int(11) NOT NULL,
  `contents` text CHARACTER SET utf8 NOT NULL,
  `device` int(11) NOT NULL,
  PRIMARY KEY (`id`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_app_learning_infors`
--

CREATE TABLE IF NOT EXISTS `spp_app_learning_infors` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `application_code` varchar(10) NOT NULL,
  `subscription_number` int(11) DEFAULT NULL,
  `average_learning_time` bigint(18) DEFAULT NULL,
  `learning_time_total` bigint(18) DEFAULT NULL,
  PRIMARY KEY (`id`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_app_time_usages`
--

CREATE TABLE IF NOT EXISTS `spp_app_time_usages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `application_code` varchar(10) DEFAULT NULL,
  `usage_type` int(11) DEFAULT NULL,
  `usage_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_client_learning_infors`
--

CREATE TABLE IF NOT EXISTS `spp_client_learning_infors` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_code` varchar(10) DEFAULT NULL,
  `application_code` varchar(10) DEFAULT NULL,
  `learning_time_total` bigint(18) DEFAULT NULL,
  `learning_start_date` date DEFAULT NULL,
  `progress_rate` int(11) DEFAULT NULL,
  `correct_rate` int(11) DEFAULT NULL,
  `days_of_usage` int(11) DEFAULT NULL,
  `profile_sex` varchar(6) DEFAULT NULL,
  `profile_age` int(11) DEFAULT NULL,
  `profile_career` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_contents`
--

CREATE TABLE IF NOT EXISTS `spp_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_type` char(1) DEFAULT NULL,
  `content_code` varchar(32) DEFAULT NULL,
  `content_name` varchar(256) DEFAULT NULL,
  `sale_start_date` date DEFAULT NULL,
  `sale_end_date` date DEFAULT NULL,
  `builtin_flag` tinyint(1) DEFAULT NULL,
  `license_flag` tinyint(1) DEFAULT NULL,
  `store_flag` tinyint(1) DEFAULT NULL,
  `before_purchase_desc` text,
  `after_purchase_desc` text,
  `comment` text,
  `active_flag` tinyint(1) DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  `created_datetime` datetime DEFAULT NULL,
  `updated_datetime` datetime DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `content_code_UNIQUE` (`content_code`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_content_files`
--

CREATE TABLE IF NOT EXISTS `spp_content_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `before_download_desc` text,
  `file_name` varchar(256) DEFAULT NULL,
  `file_size` int(10) unsigned DEFAULT NULL,
  `file_content` longblob,
  `active_flag` tinyint(1) DEFAULT NULL,
  `version` int(10) unsigned DEFAULT NULL,
  `created_datetime` datetime DEFAULT NULL,
  `updated_datetime` datetime DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `content_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_content_items`
--

CREATE TABLE IF NOT EXISTS `spp_content_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(10) unsigned DEFAULT NULL,
  `child_content_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_content_items_1` (`content_id`,`child_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `spp_device_tokens`
--

CREATE TABLE IF NOT EXISTS `spp_device_tokens` (
  `device_id` text CHARACTER SET utf8 NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_learnings`
--

CREATE TABLE IF NOT EXISTS `spp_learnings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `application_code` varchar(10) DEFAULT NULL,
  `client_code` varchar(10) DEFAULT NULL,
  `learning_date` date DEFAULT NULL,
  `learning_duration` bigint(18) DEFAULT NULL,
  PRIMARY KEY (`id`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_learning_logs`
--

CREATE TABLE IF NOT EXISTS `spp_learning_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `application_code` varchar(10) DEFAULT NULL,
  `client_code` varchar(10) DEFAULT NULL,
  `time_start` datetime DEFAULT NULL,
  `time_end` datetime DEFAULT NULL,
  `learning_date` date DEFAULT NULL,
  `learning_duration` int(11) DEFAULT NULL,
  `batch_flag` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_licenses`
--

CREATE TABLE IF NOT EXISTS `spp_licenses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `license_code` varchar(32) DEFAULT NULL,
  `license_desc` varchar(256) DEFAULT NULL,
  `expired_start_date` date DEFAULT NULL,
  `expired_end_date` date DEFAULT NULL,
  `comment` text,
  `client_identifier_no` varchar(16) DEFAULT NULL,
  `client_used_date` date DEFAULT NULL,
  `creator_id` int(10) unsigned DEFAULT NULL,
  `created_datetime` datetime DEFAULT NULL,
  `updated_datetime` datetime DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `license_code_UNIQUE` (`license_code`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_license_contents`
--

CREATE TABLE IF NOT EXISTS `spp_license_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `license_id` int(10) unsigned DEFAULT NULL,
  `content_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_license_contents_1` (`license_id`,`content_id`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_messages`
--

CREATE TABLE IF NOT EXISTS `spp_messages` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `message` varchar(60) CHARACTER SET utf8 NOT NULL,
  `created_datetime` datetime NOT NULL,
  `success` int(11) NOT NULL,
  `fail` int(11) NOT NULL,
  PRIMARY KEY (`id`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_quiz_incorrect_logs`
--

CREATE TABLE IF NOT EXISTS `spp_quiz_incorrect_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `application_code` varchar(10) DEFAULT NULL,
  `client_code` varchar(10) DEFAULT NULL,
  `content_id` varchar(100) DEFAULT NULL,
  `category_no` int(11) DEFAULT NULL,
  `category_name` varchar(100) DEFAULT NULL,
  `subcategory_no` int(11) DEFAULT NULL,
  `subcategory_name` varchar(100) DEFAULT NULL,
  `quiz_no` int(11) DEFAULT NULL,
  `incorrect_count` int(11) DEFAULT NULL,
  `batch_flag` tinyint(1) DEFAULT NULL,
  `insert_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_quiz_incorrect_statistics`
--

CREATE TABLE IF NOT EXISTS `spp_quiz_incorrect_statistics` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` varchar(100) DEFAULT NULL,
  `category_no` int(11) DEFAULT NULL,
  `category_name` varchar(100) DEFAULT NULL,
  `subcategory_no` int(11) DEFAULT NULL,
  `subcategory_name` varchar(100) DEFAULT NULL,
  `quiz_no` int(11) DEFAULT NULL,
  `insert_date` datetime DEFAULT NULL,
  `incorrect_count` int(11) DEFAULT NULL,
  `application_code` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_roles`
--

CREATE TABLE IF NOT EXISTS `spp_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_code` varchar(32) DEFAULT NULL,
  `role_name` varchar(256) DEFAULT NULL,
  `created_datetime` datetime DEFAULT NULL,
  `updated_datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `role_code_UNIQUE` (`role_code`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_users`
--

CREATE TABLE IF NOT EXISTS `spp_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_name` varchar(32) DEFAULT NULL,
  `user_pwd` varchar(50) DEFAULT NULL,
  `user_desc` varchar(256) DEFAULT NULL,
  `pwd_ng_time` int(11) DEFAULT NULL,
  `limited_datetime` datetime DEFAULT NULL,
  `locked_datetime` datetime DEFAULT NULL,
  `created_datetime` datetime DEFAULT NULL,
  `updated_datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_name_UNIQUE` (`user_name`)
);

-- --------------------------------------------------------

--
-- Table structure for table `spp_user_roles`
--

CREATE TABLE IF NOT EXISTS `spp_user_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `role_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_user_roles_1` (`user_id`,`role_id`)
);



--
-- テーブルの構造 `spp_category`
--

CREATE TABLE IF NOT EXISTS `spp_category` (
  `id` int(10) NOT NULL,
  `category_no` int(10) DEFAULT NULL,
  `category_name` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
);


CREATE TABLE IF NOT EXISTS `spp_study_category_records` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `license_code` varchar(32) CHARACTER SET latin1 NOT NULL,
  `category_no` int(10) DEFAULT NULL,
  `quiz_count` int(10) DEFAULT NULL,
  `try_count` int(10) DEFAULT NULL,
  `miss_count` int(10) DEFAULT NULL,
  `achievement` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
);



CREATE TABLE IF NOT EXISTS `spp_study_records` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `license_code` varchar(32) CHARACTER SET latin1 NOT NULL,
  `client_identifier_no` varchar(16) CHARACTER SET latin1 NOT NULL,
  `client_code` varchar(10) CHARACTER SET latin1 NOT NULL,
  `all_quiz_count` int(10) DEFAULT NULL,
  `all_try_count` int(10) DEFAULT NULL,
  `all_miss_count` int(10) DEFAULT NULL,
  `all_achievement` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
);

ALTER TABLE  `spp_client_learning_infors` ADD INDEX (`client_code`,`application_code`) ;
ALTER TABLE  `spp_learnings` ADD INDEX (`learning_date`) ;

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_active_contents`
--
CREATE TABLE IF NOT EXISTS `v_active_contents` (
`id` int(11) unsigned
,`content_type` char(1)
,`content_code` varchar(32)
,`content_name` varchar(256)
,`sale_start_date` date
,`sale_end_date` date
,`builtin_flag` tinyint(4)
,`license_flag` tinyint(4)
,`store_flag` tinyint(4)
,`before_purchase_desc` text
,`after_purchase_desc` text
,`comment` text
,`active_flag` tinyint(4)
,`version` int(11)
);
-- --------------------------------------------------------


--
-- Dumping data for table `spp_roles`
--

INSERT INTO `spp_roles` (`id`, `role_code`, `role_name`, `created_datetime`, `updated_datetime`) VALUES
(1, 'USER_MANAGEMENT', 'USER_MANAGEMENT', NULL, NULL),
(2, 'CONTENT_MANAGEMENT', 'CONTENT_MANAGEMENT', NULL, NULL),
(3, 'LICENSE_MANAGEMENT', 'LICENSE_MANAGEMENT', NULL, NULL),
(4, 'DOWNLOAD_MANAGEMENT', 'DOWNLOAD_MANAGEMENT', NULL, NULL),
(5, 'USER_MANAGEMENT_VIEW', 'USER_MANAGEMENT_VIEW', NULL, NULL),
(7, 'CONTENT_MANAGEMENT_VIEW', 'CONTENT_MANAGEMENT_VIEW', NULL, NULL),
(8, 'LICENSE_MANAGEMENT_VIEW', 'LICENSE_MANAGEMENT_VIEW', NULL, NULL),
(9, 'PUSH_MANAGEMENT', 'PUSH_MANAGEMENT', NULL, NULL),
(10, 'PUSH_MANAGEMENT_VIEW', 'PUSH_MANAGEMENT_VIEW', NULL, NULL);

--
-- Dumping data for table `spp_users`
--

INSERT INTO `spp_users` (`id`, `user_name`, `user_pwd`, `user_desc`, `pwd_ng_time`, `limited_datetime`, `locked_datetime`, `created_datetime`, `updated_datetime`) VALUES
(1, 'sysadmin', 'e10adc3949ba59abbe56e057f20f883e', 'SYSTEM ADMINISTRATOR', 0, NULL, NULL, NULL, NULL);

--
-- Dumping data for table `spp_user_roles`
--

INSERT INTO `spp_user_roles` (`id`, `user_id`, `role_id`) VALUES
(462, 1, 1),
(463, 1, 2),
(464, 1, 3),
(466, 1, 4),
(465, 1, 9);

--
-- Structure for view `v_active_contents`
--
DROP TABLE IF EXISTS `v_active_contents`;

CREATE VIEW `v_active_contents` AS select `sc`.`id` AS `id`,`sc`.`content_type` AS `content_type`,`sc`.`content_code` AS `content_code`,`sc`.`content_name` AS `content_name`,`sc`.`sale_start_date` AS `sale_start_date`,`sc`.`sale_end_date` AS `sale_end_date`,`sc`.`builtin_flag` AS `builtin_flag`,`sc`.`license_flag` AS `license_flag`,`sc`.`store_flag` AS `store_flag`,`sc`.`before_purchase_desc` AS `before_purchase_desc`,`sc`.`after_purchase_desc` AS `after_purchase_desc`,`sc`.`comment` AS `comment`,`sc`.`active_flag` AS `active_flag`,`sc`.`version` AS `version` from (`spp_contents` `sc` join `spp_content_files` `scf`) where ((`sc`.`active_flag` = 1) and (`sc`.`sale_start_date` <= curdate()) and (`sc`.`sale_end_date` >= curdate()) and (`sc`.`id` = `scf`.`content_id`) and (`scf`.`active_flag` = 1)) union all select `sc`.`id` AS `id`,`sc`.`content_type` AS `content_type`,`sc`.`content_code` AS `content_code`,`sc`.`content_name` AS `content_name`,`sc`.`sale_start_date` AS `sale_start_date`,`sc`.`sale_end_date` AS `sale_end_date`,`sc`.`builtin_flag` AS `builtin_flag`,`sc`.`license_flag` AS `license_flag`,`sc`.`store_flag` AS `store_flag`,`sc`.`before_purchase_desc` AS `before_purchase_desc`,`sc`.`after_purchase_desc` AS `after_purchase_desc`,`sc`.`comment` AS `comment`,`sc`.`active_flag` AS `active_flag`,`sc`.`version` AS `version` from (((`spp_contents` `sc` join `spp_content_items` `sci`) join `spp_contents` `scc`) join `spp_content_files` `scf`) where ((`sc`.`active_flag` = 1) and (`sc`.`sale_start_date` <= curdate()) and (`sc`.`sale_end_date` >= curdate()) and (`sc`.`id` = `sci`.`content_id`) and (`sci`.`child_content_id` = `scc`.`id`) and (`scc`.`active_flag` = 1) and (`scc`.`sale_start_date` <= curdate()) and (`scc`.`sale_end_date` >= curdate()) and (`scc`.`id` = `scf`.`content_id`) and (`scf`.`active_flag` = 1));

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
