ALTER TABLE  `spp_contents` ADD  `subscribe_flag` TINYINT( 1 ) NOT NULL DEFAULT  '0' AFTER  `store_flag`;

CREATE  OR REPLACE VIEW `v_active_contents` AS
    SELECT 
        `sc`.`id` AS `id`,
        `sc`.`content_type` AS `content_type`,
        `sc`.`content_code` AS `content_code`,
        `sc`.`content_name` AS `content_name`,
        `sc`.`sale_start_date` AS `sale_start_date`,
        `sc`.`sale_end_date` AS `sale_end_date`,
        `sc`.`builtin_flag` AS `builtin_flag`,
        `sc`.`license_flag` AS `license_flag`,
        `sc`.`store_flag` AS `store_flag`,
        `sc`.`subscribe_flag` AS `subscribe_flag`,
        `sc`.`before_purchase_desc` AS `before_purchase_desc`,
        `sc`.`after_purchase_desc` AS `after_purchase_desc`,
        `sc`.`comment` AS `comment`,
        `sc`.`active_flag` AS `active_flag`,
        `sc`.`version` AS `version`
    FROM
        (`spp_contents` `sc`
        JOIN `spp_content_files` `scf`)
    WHERE
        ((`sc`.`active_flag` = 1)
            AND (`sc`.`sale_start_date` <= CURDATE())
            AND (`sc`.`sale_end_date` >= CURDATE())
            AND (`sc`.`id` = `scf`.`content_id`)
            AND (`scf`.`active_flag` = 1)) 
    UNION ALL SELECT 
        `sc`.`id` AS `id`,
        `sc`.`content_type` AS `content_type`,
        `sc`.`content_code` AS `content_code`,
        `sc`.`content_name` AS `content_name`,
        `sc`.`sale_start_date` AS `sale_start_date`,
        `sc`.`sale_end_date` AS `sale_end_date`,
        `sc`.`builtin_flag` AS `builtin_flag`,
        `sc`.`license_flag` AS `license_flag`,
        `sc`.`store_flag` AS `store_flag`,
        `sc`.`subscribe_flag` AS `subscribe_flag`,
        `sc`.`before_purchase_desc` AS `before_purchase_desc`,
        `sc`.`after_purchase_desc` AS `after_purchase_desc`,
        `sc`.`comment` AS `comment`,
        `sc`.`active_flag` AS `active_flag`,
        `sc`.`version` AS `version`
    FROM
        (((`spp_contents` `sc`
        JOIN `spp_content_items` `sci`)
        JOIN `spp_contents` `scc`)
        JOIN `spp_content_files` `scf`)
    WHERE
        ((`sc`.`active_flag` = 1)
            AND (`sc`.`sale_start_date` <= CURDATE())
            AND (`sc`.`sale_end_date` >= CURDATE())
            AND (`sc`.`id` = `sci`.`content_id`)
            AND (`sci`.`child_content_id` = `scc`.`id`)
            AND (`scc`.`active_flag` = 1)
            AND (`scc`.`sale_start_date` <= CURDATE())
            AND (`scc`.`sale_end_date` >= CURDATE())
            AND (`scc`.`id` = `scf`.`content_id`)
            AND (`scf`.`active_flag` = 1));