import db from './db.js';
import SubCategory from './sub_category.js';
import Quiz from './quiz.js';
import Continue from './continue.js';
import Record from './record.js';
import Contents from "./contents";
import config from "./config";
const page      = require('page');

export default class Category {

    getCategoriesList(categoryNo, learnerId) {
        return db.transaction('r', db.category, db.quizzes, db.record, db.sub_category, db.continue_quiz, async () => {
            var subCategoryRepo = new SubCategory();
            var quizRepo        = new Quiz();
            var continueObj = new Continue();
            let categorySelect;

            var rec = new Record();

            let bigCategory = await db.category.orderBy('category_no').toArray();
            // Remove duplicate category_notation
            for(var i = 0; i < bigCategory.length; i++) {
                for(var j = i + 1; j < bigCategory.length; ) {
                    if(bigCategory[i]['category_notation'] == bigCategory[j]['category_notation'])
                        bigCategory.splice(j, 1);
                    else
                        j++;
                }
            }
            
            var bookmark_quiz  = await quizRepo.findBookmarkQuiz();

            let categories =  await db.category.orderBy('category_no').toArray((categories) => {
                return new Promise.all(categories.map(async (category) => {
                    let categoryNo         = category.category_no;

	var startTime = Date.now(); 
                    let totalQuiz         = await quizRepo.getTotalQuizOfCategory(categoryNo);
	var endTime = Date.now(); 
	console.log("catNo:"+categoryNo+" getTotalQuizOfCategory:"+(endTime - startTime));
                    let totalAnsweredQuiz = await quizRepo.getTotalNoAnsweredQuizOfCategory(categoryNo);
	var endTime2 = Date.now(); 
	console.log("catNo:"+categoryNo+" getTotalNoAnsweredQuizOfCategory:"+(endTime2 - endTime));

					let totalIncorrectQuiz = await rec.getTotalIncorrectCount(categoryNo);
	var endTime3 = Date.now(); 
	console.log("catNo:"+categoryNo+" getTotalIncorrectCount:"+(endTime3 - endTime2));
					console.log("categoryNo:"+categoryNo+" totalIncorrectQuiz:"+totalIncorrectQuiz);
					
					//let incorrectQuizz = await rec.getIncorrectQuizNumbers(categoryNo);
					//console.log("incorrectQuizz:"+incorrectQuizz.join(","));
					
                    category.totalCategory = totalQuiz;
                    category.totalAnsweredQuiz = totalAnsweredQuiz;

                    category.totalIncorrectQuiz = totalIncorrectQuiz;

                    let subCategories = await subCategoryRepo
                        .findByParentCategory(categoryNo)
                        .then((subCategories) => {
                            return subCategories.sortBy('subcategory_no');
                        }).then((subCategories) => {
                            return new Promise.all(subCategories.map(async (subCategory) => {
                                let subCategoryNo = subCategory.subcategory_no;
                                subCategory.subfolder = config.subfolder;
                                return subCategory;
                            }));
                        });

                    if(subCategories.length)
                    {
                        var continueQuiz = await continueObj.findContinueQuiz(categoryNo);
                        category.subCategories = subCategories;
                        category.subfolder = config.subfolder;

                        if(continueQuiz){
                            category.continue_quiz = config.subfolder+ "/quiz/continue/" + categoryNo + "/" + continueQuiz.subcategory_no;
                        }
                        else
                        {
                            category.continue_quiz = config.subfolder+ "/quiz/continue/" + categoryNo + "/" + subCategories[0].subcategory_no;
                        }
                        
                        category.bookmark_quiz = config.subfolder+ "/quiz/bookmark/" + category.category_no + "/";
                        category.not_answered_yet = config.subfolder+ "/quiz/not-answered-yet/" + category.category_no +"/"+ subCategories[0].subcategory_no;;
                        category.random_quiz = config.subfolder+ "/quiz/random/" + category.category_no +"/"+ subCategories[0].subcategory_no;
                        category.red_sheet_quiz = config.subfolder+ "/quiz/red-sheet/" + category.category_no +"/"+ subCategories[0].subcategory_no ;

                        return category;
                    }
                }));
            }).then((categories) =>
                categories.filter(
                    function (categories) {
                        return (categories && categories.totalCategory > 0);
                    }
                )
            );

            var bigCate = [];
            bigCategory.forEach(element =>  {
                var cate = [];
                cate.push(categories.filter(function (category) {
                        if (category['category_notation'] == element['category_notation']){
                            category['bigcategory'] = element["id"]
                            return category;
                        }
                    })
                ) ;
                element.subfolder = config.subfolder;
                element.categories = cate[0];
                bigCate.push(element);
            });
            return bigCate;
        });
    }

    getCategoriesHaveAnsweredQuizzes(categoryNo, learnerId) {
        return db.transaction('r', db.category, db.quizzes, db.record, db.sub_category, async () => {
            var subCategoryRepo = new SubCategory();
            var quizRepo        = new Quiz();
            let categorySelect;

            let categories = await db.category.toArray();
            if (categories.length > 0) {
                if (typeof continueQiuz !== 'undefined') {
                    var selectFilter = categories.filter(function (category) {
                        return category.category_no == continueQiuz.category_no;
                    });
                    categorySelect = selectFilter[0];
                } else {
                    categorySelect = categories[0];
                }

                if (typeof categorySelect == 'undefined') {
                    return page.redirect(config.subfolder + config.error_page);
                }

                for (var i = 0; i < categories.length; i++) {
                    if (categories[i].category_no == categorySelect.category_no) {
                        categories[i].selected = 'selected';
                        categories.selectName = categories[i].category_name;
                    }
                }

                let totalQuiz         = await quizRepo.getTotalQuizOfCategory(categorySelect.category_no);
                let totalAnsweredQuiz = await quizRepo.getTotalAnsweredQuizOfCategory(categorySelect.category_no);

                categories.totalAnsweredQuizRate = totalAnsweredQuiz;
                categories.totalQuizOfCategory = totalQuiz;

                let subCategories = await subCategoryRepo
                    .findByParentCategory(categorySelect.category_no)
                    .then((sub_categories) => {
                        return sub_categories.toArray();
                    })
                    .then((subCategories) => {
                        return new Promise.all(subCategories.map(async (subCategory) => {
                            let totallQuizOfSubCategory = await quizRepo.getTotallQuizOfSubCategory(categorySelect.category_no, subCategory.subcategory_no);
                            subCategory.totallQuizOfSubCategory = totallQuizOfSubCategory;
                            subCategory.subfolder = config.subfolder;

                            return subCategory;
                        }));
                    });

                categories.category_select = categorySelect;
                categories.subCategories = subCategories;

                return categories;
            } else {
                return null;
            }
        });
    }

    getCategoriesContinueQuizzes(continueQiuz) {
        return db.transaction('r', db.category, db.quizzes, db.record, db.sub_category, async () => {
            var subCategoryRepo = new SubCategory();
            var quizRepo        = new Quiz();
            let categorySelect;

            let categories = await db.category.toArray();

            if (categories.length > 0) {
                if (typeof continueQiuz !== 'undefined') {
                    var selectFilter = categories.filter(function (category) {
                        return category.category_no == continueQiuz.category_no;
                    });
                    categorySelect = selectFilter[0];
                } else {
                    categorySelect = categories[0];
                }

                if (typeof categorySelect == 'undefined') {
                    return page.redirect(config.subfolder + config.error_page);
                }

                for (var i = 0; i < categories.length; i++) {
                    if (categories[i].category_no == categorySelect.category_no) {
                        categories[i].selected = 'selected';
                        categories.selectName = categories[i].category_name;
                    }
                }

                let totalQuiz         = await quizRepo.getTotalQuizOfCategory(categorySelect.category_no);
                let totalAnsweredQuiz = await quizRepo.getTotalAnsweredQuizOfCategory(categorySelect.category_no);

                categories.totalAnsweredQuizRate = totalAnsweredQuiz;
                categories.totalQuizOfCategory = totalQuiz;

                let subCategories = await subCategoryRepo
                    .findBySubCategory(categorySelect.category_no, continueQiuz.subcategory_no)
                    .then((sub_categories) => {
                        return sub_categories.toArray();
                    })
                    .then((subCategories) => {
                        return new Promise.all(subCategories.map(async (subCategory) => {

                            let totallQuizOfSubCategory = await quizRepo.getTotallQuizOfSubCategory(continueQiuz.category_no, continueQiuz.subcategory_no);
                            subCategory.totallQuizOfSubCategory = totallQuizOfSubCategory;
                            subCategory.subfolder = config.subfolder;

                            return subCategory;
                        }));
                    });

                categories.category_select = categorySelect;
                categories.subCategories = subCategories;

                return categories;
            } else {
                return null;
            }
        });
    }

    getCategoriesHaveIncorrectAnsweredQuizzes(categoryNo, learnerId) {
        return db.transaction('r', db.category, db.quizzes, db.record, db.sub_category, async () => {
            var subCategoryRepo = new SubCategory();
            var quizRepo        = new Quiz();
            let categorySelect;

            let categories = await db.category.toArray();
            if (categories.length > 0) {
                if (categoryNo == 0 || isNaN(categoryNo)) {
                    categorySelect = categories[0];
                } else {
                    var selectFilter = categories.filter(function (category) {
                        return category.category_no == categoryNo;
                    });
                    categorySelect = selectFilter[0];
                }

                if (typeof categorySelect == 'undefined') {
                    return page.redirect(config.subfolder + config.error_page);
                }

                let totalQuiz         = await quizRepo.getTotalQuizOfCategory(categorySelect.category_no);
                let totalIncorrectAnsweredQuiz = await quizRepo.getTotalIncorrectAnsweredQuizOfCategory(categorySelect.category_no);

                categories.totalIncorrectAnsweredQuiz = totalIncorrectAnsweredQuiz;
                categories.totalQuizOfCategory = totalQuiz;

                for (var i = 0; i < categories.length; i++) {
                    // categorySelect = categories[0];
                    if (categories[i].category_no == categorySelect.category_no) {
                        categories[i].selected = 'selected';
                        categories.selectName = categories[i].category_name;
                    }
                }

                let subCategories = await subCategoryRepo
                    .findByParentCategory(categorySelect.category_no)
                    .then((subCategories) => {
                        return subCategories.toArray();
                    }).then((subCategories) => {
                        return new Promise.all(subCategories.map(async (subCategory) => {
                            let subCategoryNo = subCategory.subcategory_no;
                            let totalIncorrectAnsweredQuizOfSubCategory =
                                await quizRepo
                                    .getTotalIncorrectAnsweredQuizOfSubCategory(categorySelect.category_no, subCategoryNo)
                                    .then((x) => x);

                            subCategory.totalIncorrectAnsweredQuizOfSubCategory = totalIncorrectAnsweredQuizOfSubCategory;
                            subCategory.subfolder = config.subfolder;

                            return subCategory;
                        }));
                    }).then((subCategories) =>
                        subCategories.filter(
                            function (subCategory) {
                                return subCategory.totalIncorrectAnsweredQuizOfSubCategory > 0;
                            }
                        )
                    );

                categories.category_select = categorySelect;
                categories.subCategories = subCategories;

                return categories;
            } else {
                return null;
            }
        });
    }

    getCategoriesHaveUnansweredQuizzes(categoryNo, learnerId) {
        return db.transaction('r', db.category, db.quizzes, db.record, db.sub_category, async () => {
            var subCategoryRepo = new SubCategory();
            var quizRepo        = new Quiz();
            let categorySelect;

            let categories = await db.category.toArray();
            if (categories.length > 0) {
                if (categoryNo == 0 || isNaN(categoryNo)) {
                    categorySelect = categories[0];
                } else {
                    var selectFilter = categories.filter(function (category) {
                        return category.category_no == categoryNo;
                    });
                    categorySelect = selectFilter[0];
                }

                if (typeof categorySelect == 'undefined') {
                    return page.redirect(config.subfolder + config.error_page);
                }

                for (var i = 0; i < categories.length; i++) {
                    if (categories[i].category_no == categorySelect.category_no) {
                        categories[i].selected = 'selected';
                        categories.selectName = categories[i].category_name;
                    }
                }

                let totalQuiz         = await quizRepo.getTotalQuizOfCategory(categorySelect.category_no);
                let totalUnansweredQuiz = await quizRepo.getTotalUnansweredQuizOfCategory(categorySelect.category_no);

                categories.totalUnansweredQuiz = totalUnansweredQuiz;
                categories.totalQuizOfCategory = totalQuiz;

                let subCategories = await subCategoryRepo
                    .findByParentCategory(categorySelect.category_no)
                    .then((subCategories) => {
                        return subCategories.toArray();
                    })
                    .then((subCategories) => {
                        return new Promise.all(subCategories.map(async (subCategory) => {
                            let subCategoryNo = subCategory.subcategory_no;
                            let totalUnansweredQuizOfSubCategory =
                                await quizRepo
                                    .getTotalUnansweredQuizOfSubCategory(categorySelect.category_no, subCategoryNo)
                                    .then((x) => x);

                            subCategory.totalUnansweredQuizOfSubCategory = totalUnansweredQuizOfSubCategory;
                            subCategory.subfolder = config.subfolder;

                            return subCategory;
                        }));
                    })
                    .then((subCategories) =>
                            subCategories.filter(
                                (subCategory) => subCategory.totalUnansweredQuizOfSubCategory
                            )
                        // categories.filter(
                        //     function (category) {
                        //         return category.totalUnansweredQuizOfSubCategory > 0;
                        //     })
                    );

                categories.category_select = categorySelect;
                categories.subCategories = subCategories;

                return categories;
            } else {
                return null;
            }
        });
    }

    getCategoriesHaveBookmarkQuizzes(categoryNo, learnerId) {
        return db.transaction('r', db.category, db.quizzes, db.record, db.sub_category, async () => {
            var subCategoryRepo = new SubCategory();
            var quizRepo        = new Quiz();
            let categorySelect;

            let categories = await db.category.toArray();
            if (categories.length > 0) {
                if (categoryNo == 0 || isNaN(categoryNo)) {
                    categorySelect = categories[0];
                } else {
                    var selectFilter = categories.filter(function (category) {
                        return category.category_no == categoryNo;
                    });
                    categorySelect = selectFilter[0];
                }
                if (typeof categorySelect == 'undefined') {
                    return page.redirect(config.subfolder + config.error_page);
                }

                for (var i = 0; i < categories.length; i++) {
                    if (categories[i].category_no == categorySelect.category_no) {
                        categories[i].selected = 'selected';
                        categories.selectName = categories[i].category_name;
                    }
                }

                let totalQuiz         = await quizRepo.getTotalQuizOfCategory(categorySelect.category_no);
                let totalBookmarkQuizRate = await quizRepo.getTotalBookmarkQuizOfCategory(categorySelect.category_no);

                categories.totalBookmarkQuizRate = totalBookmarkQuizRate;
                categories.totalQuizOfCategory = totalQuiz;

                let subCategories = await subCategoryRepo
                    .findByParentCategory(categorySelect.category_no)
                    .then((subCategories) => {
                        return subCategories.toArray();
                    })
                    .then((subCategories) => {
                        return new Promise.all(subCategories.map(async (subCategory) => {
                            let subCategoryNo = subCategory.subcategory_no;
                            let totalBookmarkQuizOfSubCategory =
                                await quizRepo
                                    .getTotalBookmarkQuizOfSubCategory(categorySelect.category_no, subCategoryNo)
                                    .then((x) => x);

                            subCategory.totalBookmarkQuizOfSubCategory = totalBookmarkQuizOfSubCategory;
                            subCategory.subfolder = config.subfolder;

                            return subCategory;
                        }));
                    })
                    .then((subCategories) =>
                            subCategories.filter(
                                (subCategory) => subCategory.totalBookmarkQuizOfSubCategory
                            )
                    );

                categories.category_select = categorySelect;
                categories.subCategories = subCategories;

                return categories;
            } else {
                return null
            }

        });
    }

    getAllCategoriesRandom(categoryNo) {
        return db.transaction('r', db.category, db.quizzes, db.record, db.sub_category, async () => {
            var subCategoryRepo = new SubCategory();
            var quizRepo        = new Quiz();
            let categorySelect;

            let categories = await db.category.toArray();
            if (categories.length > 0) {
                if (categoryNo == 0 || isNaN(categoryNo)) {
                    categorySelect = categories[0];
                } else {
                    var selectFilter = categories.filter(function (category) {
                        return category.category_no == categoryNo;
                    });
                    categorySelect = selectFilter[0];
                }

                if (typeof categorySelect == 'undefined') {
                    return page.redirect(config.subfolder + config.error_page);
                }

                for (var i = 0; i < categories.length; i++) {
                    if (categories[i].category_no == categorySelect.category_no) {
                        categories[i].selected = 'selected';
                        categories.selectName = categories[i].category_name;
                    }
                }

                let totalQuiz         = await quizRepo.getTotalQuizOfCategory(categorySelect.category_no);
                let totalAnsweredQuiz = await quizRepo.getTotalAnsweredQuizOfCategory(categorySelect.category_no);
                let totalUnansweredQuiz = totalQuiz - totalAnsweredQuiz;

                categories.totalAnsweredQuiz = totalAnsweredQuiz;
                categories.totalQuizOfCategory = totalQuiz;
                categories.totalUnansweredQuiz = totalUnansweredQuiz;

                let subCategories = await subCategoryRepo
                    .findByParentCategory(categorySelect.category_no)
                    .then((subCategories) => subCategories.toArray())
                    .then((subCategories) => {
                        return new Promise.all(subCategories.map(async (subCategory) => {
                            let subCategoryNo = subCategory.subcategory_no;
                            subCategory.subfolder = config.subfolder;
                            return subCategory;
                        }));
                    });

                categories.category_select = categorySelect;
                categories.subCategories = subCategories;

                return categories;
            } else {
                return null
            }

        });
    }

    getAllCategories() {
        return db.transaction('r', db.category, db.quizzes, db.record, db.sub_category, function() {
            var subCategoryRepo = new SubCategory();
            var quizRepo        = new Quiz();

            return db.category.toArray((categories) => {
                return new Promise.all(categories.map(async (category) => {
                    let categoryNo = category.category_no;
                    let totalQuiz = await quizRepo.getTotalQuizOfCategory(categoryNo);

                    category.totalQuizOfCategory = totalQuiz;

                    let subCategories = await subCategoryRepo
                        .findByParentCategory(categoryNo)
                        .then((subCategories) => subCategories.toArray())
                        .then((subCategories) => {
                            return new Promise.all(subCategories.map(async (subCategory) => {
                                let subCategoryNo = subCategory.subcategory_no;
                                subCategory.subfolder = config.subfolder;

                                return subCategory;
                            }));
                        });

                    category.subCategories = subCategories;

                    return category;
                }));
            }).then((categories) =>
                categories.filter(
                    function (category) {
                        return category.totalQuizOfCategory > 0;
                    }
                )
            );
        });
    }

    findByCategoryAndSubCategoryNo(categoryNo, subCategoryNo) {
        return db.transaction('r', db.category, db.sub_category, db.quizzes, async () => {
            let quizRepo = new Quiz();
            let category = await db.category
                .where('category_no').equals(categoryNo)
                .first();

            // let categoryTotalQuiz = await quizRepo.getTotalQuizOfCategory(categoryNo);
            let subCategory = await db.sub_category
                .where('category_no').equals(categoryNo)
                .and((subCategory) => subCategory.subcategory_no == subCategoryNo)
                .first();

            // let subCategoryTotalQuiz = await quizRepo.getTotallQuizOfSubCategory(categoryNo, subCategoryNo);

            // subCategory.subCategoryTotalQuiz = subCategoryTotalQuiz ? subCategoryTotalQuiz : [];
            // category.categoryTotalQuiz       = categoryTotalQuiz;
            if (typeof subCategory != "undefined") {
                if (subCategory.subcategory_name.length > 20) {
                    subCategory.subcategory_name = subCategory.subcategory_name.substring(0, 15);
                }
            }

            category.subCategory              = subCategory;

            return category;
        });
    }

    //tung
    checkByCategoryAndSubCategoryNo(categoryNo, subCategoryNo) {
        return db.transaction('r', db.category, db.sub_category, db.quizzes, async () => {
            let quizRepo = new Quiz();
            let categories = await db.category.toArray();
            var subCategoryRepo = new SubCategory();
            firstCat = categories[0].category_no;
            let sub_categories_first = await subCategoryRepo
                        .findByParentCategory(firstCat)
                        .then((sub_categories) => {
                            return sub_categories.toArray();
                        })
                        .then((sub_categories) => {
                            return new Promise.all (sub_categories.map(async (sub_category) => {
                                let totallQuizOfSubCategory = await quizRepo.getTotallQuizOfSubCategory(firstCat, sub_category.subcategory_no).then((x) => x);
                                sub_category.totallQuizOfSubCategory = totallQuizOfSubCategory;
                                sub_category.subfolder = config.subfolder;
    
                                return sub_category;
                            }));
    
                        })
                        .then((sub_categories) =>
                            sub_categories.filter(
                                function (subCategory) {
                                    return subCategory.totallQuizOfSubCategory > 0;
                                }
                            ));
                            firstSub = sub_categories_first[0].subcategory_no;    
            let category = await db.category
                .where('category_no').equals(categoryNo)
                .first();
            let categoryTotalQuiz = await quizRepo.getTotalQuizOfCategory(categoryNo);
            let subCategory = await db.sub_category
                .where('category_no').equals(categoryNo)
                .and((subCategory) => subCategory.subcategory_no == subCategoryNo)
                .first();
            // let subCategoryTotalQuiz = await quizRepo.getTotalQuizOfSubCategory(subCategoryNo);
            let subCategoryTotalQuiz = await quizRepo.getTotallQuizOfSubCategory(categoryNo, subCategoryNo);                    
            if(subCategoryTotalQuiz != 0){
                subCategory.subCategoryTotalQuiz = subCategoryTotalQuiz ? subCategoryTotalQuiz : [];
                category.categoryTotalQuiz       = categoryTotalQuiz;
                category.subCategory              = subCategory;
                return category;
            }else{
                return false;
            }

        });
    }

    checkByCategoryPreiew(categoryNo, subCategoryNo, pageNo, mode = "nomarl") {
        return db.transaction('r', db.category, db.sub_category, db.quizzes, db.record, async () => {
        console.log("execute checkByCategoryPreiew");
            var subCategoryRepo = new SubCategory();
            let categorySelect;
            var quizRepo        = new Quiz();
            let categories =  await db.category.orderBy('category_no').toArray((categories) => {
                return new Promise.all(categories.map(async (category) => {
                    let categoryNo         = category.category_no;

                    category.totalCategory = await quizRepo.getTotallQuizOfCategory(categoryNo);

                    let subCategories = await db.sub_category
                        .where('category_no').equals(categoryNo)
                        .sortBy('subcategory_no');

                    if (mode == 'not-answered-yet') {
        console.log("total getTotallQuizNotYetOfCategory");
                        for (var i = 0; i < subCategories.length; i++){
                            var totalyet = await quizRepo.getTotallQuizNotYetOfCategory(subCategories[i]);
                            subCategories[i].totalQuizOfSubCategory = subCategories[i].totalQuizOfSubCategory - totalyet;
                        }
        console.log("total getTotallQuizNotYetOfCategory end");
                    }

                    category.subCategories = subCategories;
                    category.subfolder = config.subfolder;

                    return category;
                }));
            }).then((categories) =>
                categories.filter(
                    function (categories) {
                        return categories.totalCategory > 0;
                    }
                )
            );
            // let subCategoryTotalQuiz = await quizRepo.getTotallQuizOfSubCategory(categoryNo, subCategoryNo);

            var categoryPreNext = [];
            for (var i = 0 ; i < categories.length; i ++){
                var cateLen = categories.length-1;
                var listSubCategory = categories[i]['subCategories'];

                if (parseInt(categories[i].category_no) == categoryNo ){
                    for (var j = 0; j < listSubCategory.length; j ++) {
                        if (listSubCategory[j]['subcategory_no'] == subCategoryNo) {
                            var subCatLen = categories[i]['subCategories'].length-1;

                            if (i == cateLen) {
                                if (j == 0 && i == 0) {
                                    categoryPreNext.prevcategory = categories[cateLen]['subCategories'][[categories[cateLen]['subCategories'].length-1]];
                                } else if (j == 0 && i != 0) {
                                    categoryPreNext.prevcategory = categories[i-1]['subCategories'][categories[i-1]['subCategories'].length-1];
                                } else if (j != 0 && i != 0) {
                                    categoryPreNext.prevcategory = categories[i]['subCategories'][j-1];
                                } else if (j != 0 && i == 0) {
                                    categoryPreNext.prevcategory = categories[i]['subCategories'][j-1];
                                } else {
                                    categoryPreNext.prevcategory = categories[0]['subCategories'][0];
                                }

                                if (j == subCatLen){
                                    categoryPreNext.nextcategory = categories[0];
                                    categoryPreNext.nextcategory.subCategory = categories[0]['subCategories'][0];
                                    categoryPreNext.nextcategory.isSubCategory = false;
                                } else {
                                    categoryPreNext.nextcategory = categories[i];
                                    categoryPreNext.nextcategory.subCategory = categories[i]['subCategories'][j+1];
                                    categoryPreNext.nextcategory.isSubCategory = true;
                                }

                    console.log("return checkByCategoryPreiew0");
                                return categoryPreNext;
                            } else {

                                if (j == 0 && i == 0) {
                                    categoryPreNext.prevcategory = categories[cateLen]['subCategories'][categories[cateLen]['subCategories'].length-1];
                                } else if (j == 0 && i != 0) {
                                    categoryPreNext.prevcategory = categories[i-1]['subCategories'][categories[i-1]['subCategories'].length-1];

                                } else if (j != 0 && i != 0) {
                                    categoryPreNext.prevcategory = categories[i]['subCategories'][j-1];
                                } else if (j != 0 && i == 0) {
                                    categoryPreNext.prevcategory = categories[i]['subCategories'][j-1];
                                } else {
                                    categoryPreNext.prevcategory = categories[0]['subCategories'][0];
                                }

                                if (j == subCatLen){
                                    categoryPreNext.nextcategory = categories[i+1];
                                    categoryPreNext.nextcategory.subCategory = categories[i+1]['subCategories'][0];
                                    categoryPreNext.nextcategory.isSubCategory = false;
                                } else {
                                    categoryPreNext.nextcategory = categories[i];
                                    categoryPreNext.nextcategory.subCategory = categories[i]['subCategories'][j+1];
                                    categoryPreNext.nextcategory.isSubCategory = true;
                                }

                    console.log("return checkByCategoryPreiew1");
                                return categoryPreNext;
                            }

                        }
                    }
                }
            }
            categoryPreNext.nextcategory = categories[0];
            categoryPreNext.nextcategory.subCategory = categories[0]['subCategories'][0];
            categoryPreNext.nextcategory.isSubCategory = true;
            categoryPreNext.prevcategory = categories[0]['subCategories'][0];
                    console.log("return checkByCategoryPreiew2");

            return categoryPreNext;
        });
    }

    getQuizzesall(categoryNo, subCategoryNo) {
        return db.transaction('r', db.category, db.sub_category, db.quizzes, db.record, async () => {
            let quizRepo = new Quiz();
            // let subCategoryTotalQuiz = await quizRepo.getTotalQuizOfSubCategory(subCategoryNo);
            let subCategoryAllQuiz = await quizRepo.getQuizAllOfSubCategory(categoryNo, subCategoryNo);

            return subCategoryAllQuiz;
        });
    }
    //endtung
    
    /**
     * get Categories Statistic
     *
     * @param is_client_flg
     * @author  ChienNguyen
     * @updated 2019.01.11
     */

    getCategoriesStatistic(is_client_flg) { 
        return db.transaction('r', db.category, db.quizzes, db.record, async () => {
            var quizRepo        = new Quiz();
            var recordRepo      = new Record();

            let bigCategory = await db.category.orderBy('category_no').toArray();
            // Remove duplicate category_notation
            for(var i = 0; i < bigCategory.length; i++) {
                for(var j = i + 1; j < bigCategory.length; ) {
                    if(bigCategory[i]['category_notation'] == bigCategory[j]['category_notation'])
                        bigCategory.splice(j, 1);
                    else
                        j++;
                }
            }

            let categories = await db.category
                .filter((category) => {
                    if(is_client_flg){
                        return (
                            category.category_no >= 500 
                        );
                    }else
                    {
                        return true;
                    }
                })
                .toArray((categories) => {
                return new Promise.all(categories.map(async (category) => {
                    let categoryNo                      = category.category_no;
                    let totalQuizOfCategory             = await quizRepo.getTotalQuizOfCategory(categoryNo);
                    let totalAnsweredQuiz               = await quizRepo.getTotalAnsweredQuizOfCategory(categoryNo);
                    let totalTryCountOfCategory         = await recordRepo.getTotalTryCount(categoryNo);
                    let totalMissCountOfCategory        = await recordRepo.getTotalMissCount(categoryNo);

                    var totalProgressOfCategory         = 0,
                        totalMissOfCategory             = 0,
                        achievementOfCategory           = 0;
                    if(totalTryCountOfCategory > 0){
                        totalProgressOfCategory   = Math.round(totalTryCountOfCategory * 100 / totalQuizOfCategory);
                        totalMissCountOfCategory  = Math.round(totalMissCountOfCategory * 100 / totalTryCountOfCategory);
                        achievementOfCategory     = 100 - totalMissCountOfCategory;
                    }
                    category.totalAnsweredQuizStatistic = totalAnsweredQuiz;
                    category.totalQuizOfCategory        = totalQuizOfCategory;
                    category.totalProgressOfCategory    = totalProgressOfCategory;
                    category.totalMissCountOfCategory   = totalMissCountOfCategory;
                    category.achievementOfCategory      = achievementOfCategory;
                    return category;
                }));
            });

            var bigCate = [];
            bigCategory.forEach(element =>  {
                var cate = [];
                cate.push(categories.filter(function (category) {
                        if (category['category_notation'] == element['category_notation']){
                            return category;
                        }
                    })
                ) ;
                if(cate[0] && cate[0].length){
                    element.subfolder = config.subfolder;
                    element.categories = cate[0];
                    bigCate.push(element);
                }
            });
            return bigCate;
        });
    }
}
