import config from './config.js';
import db from "./db";
const jsCookie = require('js-cookie');
const $ = require('jquery');
const page = require('page');


export default class User {
    update(learner_id, field, value) {
        if(navigator.onLine){
            if(value.trim() == "")
                return;

            var web_app = true;
            var data = '{"learner_id":"' + learner_id + '","' + field + '":"' + value + '", "web_app":"' + web_app + '"}';
            var bs64DataUpdate = window.btoa(unescape(encodeURIComponent(data)));
            if(field != 'nickname'){
                bs64DataUpdate = window.btoa(data);
            }
            var dataRequest = {'content': bs64DataUpdate};
            $.ajax({
                method: "POST",
                url: config.url_api_update,
                data: dataRequest,
                success: function (response) {
                    if (response.result == 'OK') {
                        db.user.update(learner_id, {[field]: value}).then(function (updated) {
                            if (updated == 0) {
                                var user = jsCookie.get('user');
                                var jsonUser = $.parseJSON(user);
                                if(field =='password'){
                                    value = window.btoa(value);
                                }
                                jsonUser[field] = value;
                                jsCookie.set('user', jsonUser, { expires: 1 });
                                page.redirect(config.subfolder + config.user_detail);
                            }
                        });
                        alert('更新が成功しました。');
                    }
                    else {
                        alert('更新が失敗しました。管理者に連絡してください。')
                    }
                }
            });
        } else {
            alert(config.NETWORK.OFFLINE_PAGE);
        }
    }

    forgotPassword(email) {
        if(navigator.onLine){
            var re = /[A-Z0-9._%+-]+@[A-Z0-9.-]+.[A-Z]{2,4}/igm;
            if (email != '' && re.test(email)) {
                var data = '{"email_address":"' + email + '"}';
                var bs64DataUpdate = window.btoa(data);
                var dataRequest = {'content': bs64DataUpdate};
                $.ajax({
                    method: "POST",
                    url: config.url_api_forget_pass,
                    data: dataRequest,
                    success: function (response) {
                        if (response.result == 'OK') {
                            alert(config.MESSAGE_FORGET_PASSWORD + email)
                        }
                        else {
                            if(response.message == '') {
                                alert(config.MESSAGE_FORGET_PASSWORD_ERROR)
                            } else {
                                alert(response.message)
                            }
                        }
                    }
                });
            } else {
                alert(config.MESSAGE_FORMAT_MAIL_ERROR)
            }
        } else {
            alert(config.NETWORK.OFFLINE_PAGE);
        }
    }
}