<?php
ini_set('zlib.output_compression_level', 9);
ob_start("ob_gzhandler");

class SppapicontentController extends AppController
{
    var $name = "Sppapicontent";

    var $uses = array("SppContentFile", "SppContent", "SppContentItem", "SppQuizLog", "SppLearner", "SppQuizContinueLog","SppOrganization");

    public $autoLayout = false;
    public $autoRender = false;

    var $components = array('Security', 'Pass4v', 'Email');
    var $helpers = array("pass4v", "Html", "Form");

    var $Pass4v;

    var $Security;

    function beforeFilter() {
        parent::beforeFilter();
        Configure::load ( 'settings' );

//         if (Configure::read('useSecureAccess')) {
//             $this->Security->requireSecure();
//         }
//         $this->Security->requirePost();

        $this->Auth->allow('syncData', 'readfile', 'xcopy', 'syncDataFromServer', 'checkDataStatusOnServer', 'syncDataQuizLog', 'manualUpdateContent');
    }

    function index() {
        empty($_SERVER['HTTP_REFERER']) ? $referer = "" : $referer = $_SERVER['HTTP_REFERER'];
        $this->Pass4v->accessLog($this->name, "Warn", "(".__FUNCTION__."),Illegal Access", $referer, $_SERVER['HTTP_USER_AGENT']);
        exit;
    }

    public function syncData() {
        $xml = Configure::read('useResponseXML');

        $form = $this->params['form'];

        $dataPost = json_decode(base64_decode($form['content']),true);
        
        $is_check = ($dataPost['is_check'] == 1) ? 1 : 0;

        // Get Data Content Item & files
        $data = $this->getDataContent($is_check);

        /**
         * Add record for
         * 
         */
        $data_records = [];

        if(isset($dataPost['learner_id']))
        {
            $listRecord = $this->SppQuizLog->find('all', array(
                'conditions' => array(
                    'learner_id' => $dataPost['learner_id']
                ),
            ));



            if($listRecord)
            {
                foreach ($listRecord as $item_record) {
                    $data_records[] = array(
                        'category_no'           => (int)$item_record['SppQuizLog']['category_no'],
                        'subcategory_no'        => (int)$item_record['SppQuizLog']['subcategory_no'],
                        'quiz_no'               => (int)$item_record['SppQuizLog']['quiz_no'],
                        'try_count'             => (int)$item_record['SppQuizLog']['try_count'],
                        'incorrect_count'       => (int)$item_record['SppQuizLog']['incorrect_count'],
                        'last_answered'         => (int)$item_record['SppQuizLog']['last_answer'],
                        'last_incorrect_count'  => (int)$item_record['SppQuizLog']['incorrect_count'],
                        'selectbox'             => (int)$item_record['SppQuizLog']['selectbox'],
                        'face_marks'            => $item_record['SppQuizLog']['face_marks'],
                        'content_id'            => $item_record['SppQuizLog']['content_id'],
                        'client_id'             => '',
                        'learner_id'            => $item_record['SppQuizLog']['learner_id']
                    );
                }
            }

            if(isset($data["data"]["records"]))
            {
                $data["data"]["records"] = $data_records;
            }
        }
        

        $appCtr = new AppController();
        $appCtr->corsSSL();

        $result['message'] = $data['message'];
        $result['data'] = base64_encode(json_encode($data));

        $this->Pass4v->response($result, "(".__FUNCTION__.")",$xml);

        return;
    }

    /**
     * Sync Result Learn Quiz
     */
    public function syncDataQuizLog() {
        $appCtr = new AppController();
        $appCtr->corsSSL();
        $xml = Configure::read('useResponseXML');
        $form = $this->params['form'];
        $dataPost = json_decode(base64_decode($form['content']),true);

        $data = [];

        /**
         * get record log quiz from server
         *
         */
        $data_records = [];
        $data_continue_log = [];
        if(isset($dataPost['learner_id']))
        {
            $listRecord = $this->SppQuizLog->find('all', array(
                'conditions' => array(
                    'learner_id' => $dataPost['learner_id']
                ),
            ));

            $listQuizContinueLog = $this->SppQuizContinueLog->find('all', array(
                'conditions' => array(
                    'learner_id' => $dataPost['learner_id']
                ),
            ));

            $infoLearner = $this->SppLearner->find('first',array(
                                        'conditions'=>array(
                                            'id'    =>  $dataPost['learner_id']
                                        ))
                                    );

            // 

            if($listRecord)
            {
                foreach ($listRecord as $item_record) {
                    $data_records[] = array(
                        'category_no'           => (int)$item_record['SppQuizLog']['category_no'],
                        'subcategory_no'        => (int)$item_record['SppQuizLog']['subcategory_no'],
                        'quiz_no'               => (int)$item_record['SppQuizLog']['quiz_no'],
                        'try_count'             => (int)$item_record['SppQuizLog']['try_count'],
                        'incorrect_count'       => (int)$item_record['SppQuizLog']['incorrect_count'],
                        'last_answered'         => (int)$item_record['SppQuizLog']['last_answer'],
                        'last_incorrect_count'  => (int)$item_record['SppQuizLog']['incorrect_count'],
                        'selectbox'             => (int)$item_record['SppQuizLog']['selectbox'],
                        'face_marks'            => $item_record['SppQuizLog']['face_marks'],
                        'content_id'            => $item_record['SppQuizLog']['content_id'],
                        'client_id'             => '',
                        'learner_id'            => $item_record['SppQuizLog']['learner_id']
                    );
                }
            }

            // 
            if($listQuizContinueLog)
            {
                foreach ($listQuizContinueLog as $item_continue_log) {
                    $data_continue_log[] = array(
                        'category_no'          => (int)$item_continue_log['SppQuizContinueLog']['category_no'],
                        'quiz_no'              => (int)$item_continue_log['SppQuizContinueLog']['quiz_no'],
                        'subcategory_no'       => (int)$item_continue_log['SppQuizContinueLog']['subcategory_no']
                    );
                }
            }

            if(isset($data_records) && count($data_records))
            {
                $data["data"]["records"] = $data_records;
            }

            if(isset($data_continue_log) && count($data_continue_log))
            {
                $data["data"]["continue_logs"] = $data_continue_log;
            }

            if($infoLearner)
            {
                $data["data"]["settings_log"] = unserialize($infoLearner['SppLearner']['settings_log']);
            }
        }

        $result['message'] = $data['message'];
        $result['data'] = base64_encode(json_encode($data));
        $this->Pass4v->response($result, "(".__FUNCTION__.")",$xml);
        return;
    }

    public function manualUpdateContent() {
        $appCtr = new AppController();
        $appCtr->corsSSL();
        $xml = Configure::read('useResponseXML');
        $form = $this->params['form'];

        $query2 = $this->SppContentFile->find('all');

        if($query2)
        {
            foreach ($query2 as $dt) {
               // File name = SppContent.id + SppContentFile.version + SppContentFile.file_name
                $file_name   = $path = WWW_ROOT  . 'pwa_web' . DS . $dt['SppContentFile']['file_name'] ;

                $download_file = array(
                                'file_name'     => $file_name, 
                                'file_content'  => $dt['SppContentFile']['file_content']
                            );

               if ($this->downloadContent($download_file)) {
                   $finfo = new finfo(FILEINFO_MIME_TYPE);
                   $mime = $finfo->file($file_name);

                   // Check file is sqlite3
                   if ($mime == 'application/x-sqlite3') {
                       $filename = $file_name;

                   } else {
                       $path = pathinfo(realpath($file_name), PATHINFO_DIRNAME);

                       $zip = new ZipArchive;
                       $res = $zip->open($file_name);
                       if ($res === TRUE) {
                           $zip->extractTo($path);
                           $zip->close();

                           unlink($file_name);
                       }
                       $filename = WWW_ROOT . DS . 'pwa_web' . DS . 'spp.db';
                   }

                   $oDatabaseHandler  = new SQlite3ToJSON($filename);
                   $data  = $oDatabaseHandler->getJSONFromSQLite();

                   $folderContentId = WWW_ROOT . 'pwa_web' . DS . $data['contents'][0]['content_id'];
                   if (!is_dir($folderContentId)) {
                       mkdir($folderContentId, 0777, true);
                       $source = WWW_ROOT . 'pwa_web' .DS.  'insert_images';
                       $dist = $folderContentId . DS . 'insert_images';

                   }
                   $this->xcopy($source , $dist );

                    if( chmod($dist, 0777) ) {
                       chmod($dist, 0777);
                    }

                    if($data)
                    {
                       $data = base64_encode(json_encode($data));
                       $dt['SppContentFile']['content'] = $data;
                       $this->SppContentFile->save($dt);
                    }
                }
            }
        }
        $this->Pass4v->response(true, "(".__FUNCTION__.")",$xml);
        return;
    }

    /**
     * sync data from server
     *
     * 
     * @param  isLogin 1 or 0
     * @param  learner_id id learner
     * @param  dataClient all data from client include array id and version content
     * @return data
     * @author ChienNguyen
     * @updated 09.01.2018
     */

    public function syncDataFromServer() {
        
        $appCtr = new AppController();
        $appCtr->corsSSL();
        $xml = Configure::read('useResponseXML');
        $form = $this->params['form'];
        $dataPost = json_decode(base64_decode($form['content']),true);
        $isLogin = ($dataPost['is_login'] == 1) ? 1 : 0;
        // 
        $list_content_of_client = $dataPost['allDataForClient'] ? $dataPost['allDataForClient'] : [];

		$contents_ids = array();
        if(isset($dataPost['learner_id']))
        {
			$sql = "select org.id as id from spp_organizations org, spp_learners lea where lea.organization_code=concat(org.code_large,org.code_middle,org.code_small) and lea.id='".$dataPost['learner_id']."'";
			$ret = $this->SppLearner->query($sql);
			$organization_id = $ret[0]['org']['id'];
			$sql = "select oc.content_id from spp_organization_contents oc, spp_contents sc where oc.organization_id='$organization_id' and oc.content_id=sc.id";
 			$ret = $this->SppLearner->query($sql);
        	        $this->Pass4v->accessLog($this->name, "Warn", "(".__FUNCTION__."),ret Access", print_r($ret,true), "");
        	                foreach ($ret as $content) {
        	                	$contents_ids[] = $content['oc']['content_id'];
        	                }

        // Get Data Content Item & files
         	//$contents_ids[] = 212;
        	        $this->Pass4v->accessLog($this->name, "Warn", "(".__FUNCTION__."),Illegal Access", print_r($contents_ids,true), "");
        $data = $this->getListDataContent($isLogin, $list_content_of_client, $contents_ids);
        } else {
        	//$contents_ids[] = 212;
        // Get Data Content Item & files
        $data = $this->getListDataContent($isLogin, $list_content_of_client, $contents_ids);
        }
      
        /**
         * get record log quiz from server
         * 
         */
        $data_records = [];
        $data_continue_log = [];
        if(isset($dataPost['learner_id']))
        {
            $listRecord = $this->SppQuizLog->find('all', array(
                'conditions' => array(
                    'learner_id' => $dataPost['learner_id']
                ),
            ));

            $listQuizContinueLog = $this->SppQuizContinueLog->find('all', array(
                'conditions' => array(
                    'learner_id' => $dataPost['learner_id']
                ),
            ));

            $infoLearner = $this->SppLearner->find('first',array(
                                        'conditions'=>array(
                                            'id'    =>  $dataPost['learner_id']
                                        ))
                                    );

            // 

            if($listRecord)
            {
                foreach ($listRecord as $item_record) {
                    $data_records[] = array(
                        'category_no'           => (int)$item_record['SppQuizLog']['category_no'],
                        'subcategory_no'        => (int)$item_record['SppQuizLog']['subcategory_no'],
                        'quiz_no'               => (int)$item_record['SppQuizLog']['quiz_no'],
                        'try_count'             => (int)$item_record['SppQuizLog']['try_count'],
                        'incorrect_count'       => (int)$item_record['SppQuizLog']['incorrect_count'],
                        'last_answered'         => (int)$item_record['SppQuizLog']['last_answer'],
                        'last_incorrect_count'  => (int)$item_record['SppQuizLog']['incorrect_count'],
                        'selectbox'             => (int)$item_record['SppQuizLog']['selectbox'],
                        'face_marks'            => $item_record['SppQuizLog']['face_marks'],
                        'content_id'            => $item_record['SppQuizLog']['content_id'],
                        'client_id'             => '',
                        'learner_id'            => $item_record['SppQuizLog']['learner_id']
                    );
                }
            }

            // 
            if($listQuizContinueLog)
            {
                foreach ($listQuizContinueLog as $item_continue_log) {
                    $data_continue_log[] = array(
                        'category_no'          => (int)$item_continue_log['SppQuizContinueLog']['category_no'],
                        'quiz_no'              => (int)$item_continue_log['SppQuizContinueLog']['quiz_no'],
                        'subcategory_no'       => (int)$item_continue_log['SppQuizContinueLog']['subcategory_no']
                    );
                }
            }

            if(isset($data_records) && count($data_records))
            {
                $data["data"]["records"] = $data_records;
            }

            if(isset($data_continue_log) && count($data_continue_log))
            {
                $data["data"]["continue_logs"] = $data_continue_log;
            }

            if($infoLearner)
            {
                $data["data"]["settings_log"] = unserialize($infoLearner['SppLearner']['settings_log']);
            }
        }
        $result['message'] = $data['message'];
        $result['data'] = base64_encode(json_encode($data));
        $this->Pass4v->response($result, "(".__FUNCTION__.")",$xml);
        return;
    }

    /**
     * check data status on server
     *
     * 
     * @param  isLogin 1 or 0
     * @param  dataClient all data from client include array id and version content
     * @return IF no new or updated data [0], IF Have new data and updates [1], IF There are new data and no updates [2], IF No new data and updates available [3]
     * @author ChienNguyen
     * @updated 08.01.2018
     */
    
    public function checkDataStatusOnServer() {
        $appCtr = new AppController();
        $appCtr->corsSSL();

        $isStatusData = 0;
        $allIDForClient = array();

        $xml = Configure::read('useResponseXML');
        $form = $this->params['form'];
        // conver data post
        $content = json_decode(base64_decode($form['content']), true);

        $isLogin = ($content['is_login'] == 1) ? 1 : 0;
        // 
        $list_content_of_client = $content['allDataForClient'] ? $content['allDataForClient'] : [];

        if ($isLogin == 0) {
            $conditions_all = (
                                array(
                                    'SppContent.builtin_flag'  => '1',
                                    'SppContent.active_flag'   => '1'
                                )
                            );
        } else {
            $conditions_all = (array(
                'OR' => array(
                    'license_flag' => '1'
                ),
                'SppContent.active_flag'   => '1',
            ));
        }
       
        $condition_isset_data = array();
        // add condition
        foreach ($list_content_of_client as $content_info) {
            $tmpCondition['OR'] = array(
                'SppContent.id !='        => $content_info[0],
                'SppContent.version !='   => $content_info[1]
            );
            array_push($condition_isset_data, $tmpCondition);
            // 
            array_push($allIDForClient, $content_info[0]);
        }

        if(count($condition_isset_data))
        {
            $conditions_all['AND'] = $condition_isset_data;
        }



        $this->SppContent->unbindModel(array('belongsTo' => array('SppUser')));
        $this->SppContent->unbindModel(array('hasMany' => array('SppLicenseContent')));
        $this->SppContent->unBindModel(array('hasMany' => array('SppContentFile')));
        $this->SppContent->unBindModel(array('hasMany' => array('SppContentItem')));

        $this->SppContent->bindModel(
            array('hasOne'=>array(
                'SppContentFile' => array(
                    'foreignKey' => false,
                    'conditions' => array(
                        'SppContentFile.content_id = SppContent.id',
                        'SppContentFile.active_flag'    => 1, 
                        'SppContent.sale_start_date <=' => date('Y-m-d'),
                        'SppContent.sale_end_date >='   => date('Y-m-d'))
                ))
            )
        );
        // 
        $list_content_server = $this->SppContent->find('all', array(
            'conditions' => $conditions_all,
            'fields' => ['id','version']
        ));

        if($list_content_server)
        {   
            $isNew      = false;
            $isUpdate   = false;
            foreach ($list_content_server as $content_info) {
        	        $this->Pass4v->accessLog($this->name, "Warn", "(".__FUNCTION__."),content_info->id Access", print_r($content_info->id,true), "");
                if(in_array($content_info['SppContent']['id'], $allIDForClient))
                {
                    $isUpdate = true;
                }
                else
                {
                	if(count($allIDForClient) > 1)
                    $isNew = true;
                }
            }
            if($isNew == true && $isUpdate == true )
            {
                $isStatusData = 1;
            }
            elseif($isNew == true)
            {
                $isStatusData = 2;
            }
            elseif($isUpdate == true)
            {
                $isStatusData = 3;
            }
        }

        $result['message'] = 'OK';
        $result['result']  = $isStatusData;
        $this->Pass4v->response($result, "(".__FUNCTION__.")",$xml);
        return;
    }

    /**
     * get data content
     *
     * 
     * @param  isLogin 1 or 0
     * @param  allData all data from client include array id and version content
     * @return data
     * @author ChienNguyen
     * @updated 09.01.2018
     */

    public function getListDataContent ($isLogin, $allData,$contents_ids) {

        if ($isLogin == 0) {
            $conditions_all = (
                                array(
                                    'SppContent.builtin_flag'  => '1',
                                    'SppContent.active_flag'   => '1',
                                )
                            );
        } else {
            $conditions_all = (array(
                'OR' => array(
                    'license_flag' => '1'
                ),
                'SppContent.active_flag'   => '1',
                'SppContent.id' => $contents_ids
            ));
        }
       
        $condition_isset_data = array();
        // add condition
        foreach ($allData as $content_info) {
            $tmpCondition['OR'] = array(
                'SppContent.id !='        => $content_info[0],
                'SppContent.version !='   => $content_info[1]
            );
            array_push($condition_isset_data, $tmpCondition);
            // 
            array_push($allIDForClient, $content_info[0]);
        }

        if(count($condition_isset_data))
        {
            $conditions_all['AND'] = $condition_isset_data;
        }


        $this->SppContent->unbindModel(array('belongsTo' => array('SppUser')));
        $this->SppContent->unbindModel(array('hasMany' => array('SppLicenseContent')));
        $this->SppContent->unBindModel(array('hasMany' => array('SppContentFile')));
        $this->SppContent->unBindModel(array('hasMany' => array('SppContentItem')));

        $this->SppContent->bindModel(
            array('hasOne'=>array(
                'SppContentFile' => array(
                    'foreignKey' => false,
                    'conditions' => array(
                        'SppContentFile.content_id = SppContent.id',
                        'SppContentFile.active_flag'    => 1, 
                        'SppContent.sale_start_date <=' => date('Y-m-d'),
                        'SppContent.sale_end_date >='   => date('Y-m-d'))
                ))
            )
        );
        // 
        $query2 = $this->SppContent->find('all', array(
            'conditions' => $conditions_all
        ));

    
        $result['data'] = $result['message'] = $data = $dataSql['data'] = $pack = array();

        if (!empty($query2)) {
            foreach ($query2 as $dt) {
                $list_image = [];
                if ($dt['SppContentFile']['image_list']) {
                    $list_image = json_decode(base64_decode($dt['SppContentFile']['image_list']), true);
                }
                $dt['SppContent']['list_image'] = $list_image;
                $pack[] = $dt['SppContent'];

               if ($dt['SppContentFile']['content_base64']) {

                    $data = json_decode(base64_decode($dt['SppContentFile']['content_base64']), true);
                    $result['data'] = array_merge_recursive($result['data'], $data);

                } else {
                   $result['message'] = 'Data error !';
                }
            }
        } else {
            $result['message'] = 'No data !';
        }

        $result['data']['packaged_sync'] = $pack;
        return $result;
    }

    public function getDataContent ($is_check) {
        if ($is_check == 0) {
            $conditions = (array('SppContent.builtin_flag'  => '1', 'SppContent.active_flag'   => '1'));
        } else {
            $conditions = (array(
                'OR' => array(
                    'license_flag' => '1'
                ),
                'SppContent.active_flag'   => '1',
            ));
        }

        $this->SppContent->unbindModel(array('belongsTo' => array('SppUser')));
        $this->SppContent->unbindModel(array('hasMany' => array('SppLicenseContent')));
        $this->SppContent->unBindModel(array('hasMany' => array('SppContentFile')));
        $this->SppContent->unBindModel(array('hasMany' => array('SppContentItem')));

        $this->SppContent->bindModel(
            array('hasOne'=>array(
                'SppContentFile' => array(
                    'foreignKey' => false,
                    'conditions' => array('SppContentFile.content_id = SppContent.id', 'SppContentFile.active_flag'=> 1, 'SppContent.sale_start_date <='=> date('Y-m-d'),'SppContent.sale_end_date >='=> date('Y-m-d'))
                ))
            )
        );

        $query = $this->SppContent->find('all', array(
            'conditions' => $conditions,
        ));
        $result['data'] = $result['message'] = $data = $dataSql['data'] = $pack = array();
        if (!empty($query)) {
            foreach ($query as $dt) {
                $pack[] = $dt['SppContent'];

                // File name = SppContent.id + SppContentFile.version + SppContentFile.file_name
                $file_name   = $path = WWW_ROOT . DS . 'pwa_web' . DS . $dt['SppContentFile']['file_name'] ;

                $download_file = array('file_name' => $file_name, 'file_content' => $dt['SppContentFile']['file_content']);

               if ($this->downloadContent($download_file)) {
                   $finfo = new finfo(FILEINFO_MIME_TYPE);
                   $mime = $finfo->file($file_name);

                   // Check file is sqlite3
                   if ($mime == 'application/x-sqlite3') {
                       $filename = $file_name;

                   } else {
                       $path = pathinfo(realpath($file_name), PATHINFO_DIRNAME);

                       $zip = new ZipArchive;
                       $res = $zip->open($file_name);
                       if ($res === TRUE) {
                           $zip->extractTo($path);
                           $zip->close();

                           unlink($file_name);
                       }
                       $filename = WWW_ROOT . DS . 'pwa_web' . DS . 'spp.db';
                   }

                   $oDatabaseHandler  = new SQlite3ToJSON($filename);
                   $data  = $oDatabaseHandler->getJSONFromSQLite();

                   $folderContentId = WWW_ROOT . 'pwa_web' . DS . $data['contents'][0]['content_id'];
                   if (!is_dir($folderContentId)) {
                       mkdir($folderContentId, 0777, true);
                       $source = WWW_ROOT . 'pwa_web' .DS.  'insert_images';
                       $dist = $folderContentId . DS . 'insert_images';

                   }
                   $this->xcopy($source , $dist );

                   if( chmod($dist, 0777) ) {
                       chmod($dist, 0777);
                   }

                   $result['data'] = array_merge_recursive($result['data'], $data);


                   unlink($filename);
               } else {
                   $result['message'] = 'Data error !';
               }
            }
        } else {

            $result['message'] = 'No data !';
        }

        $result['data']['packaged_sync'] = $pack;
        return $result;
    }

    public function moveFolderTo($source, $target){
        if( !is_dir($target) ) mkdir(dirname($target),null,true);
        rename( $source,  $target);
    }

    public function downloadContent($download_file) {
        if (!file_put_contents($download_file['file_name'], $download_file['file_content']) == true) {
           return false;
        }
        return true;
    }

    function xcopy($src, $dest) {
//        $src = TMP . 'insert_images';
//        $dest = WWW_ROOT . 'img_pwa';

        if (!is_dir($dest)) {
            mkdir($dest, 0777, true);
        }

        if (is_dir($src)) {
            if ($dh = opendir($src)) {
                while (($file = readdir($dh)) !== false) {
                    //exclude unwanted

                    if ($file==".") continue;

                    if ($file=="..")continue;

                    copy("$src/$file","$dest/$file");

                }

                closedir($dh);

            }
            rmdir($src);
        }

    }

}


class SQlite3ToJSON
{
    /**
     * The SQlite 3 database
     */
    private $database = NULL;

    /**
     * Open the database by creating a new SQLite3 instance from the
     * filename given to the constructor initially
     */
    public function __construct($sDatabaseFileName = NULL) {
        $this->openDatabase($sDatabaseFileName);
    }

    /**
     * Open the database by creating a new SQLite3 instance from the
     * filename given to the constructor initially
     */
    public function openDatabase($databaseFileName = NULL) {
        $this->database = new SQLite3($databaseFileName);
        assert($this->database);
    }

    /**
     * This method returns information about the given table name
     */
    private function columnsInformationWithTableName($sTableName) {
        // Setting the query
        $sQueryColumns = "PRAGMA table_info(':name')";
        $sQueryColumns = str_replace(':name', $sTableName, $sQueryColumns);

        // Preparing the query
        $oResult = $this->database->query($sQueryColumns);

        // Fetching result and preparing formatting of the result to a
        // convenient usable format.
        $aResult = array();
        while ($aRow = $oResult->fetchArray(SQLITE3_ASSOC)) {
            $aResult[] = $aRow;
        }

        return $aResult;
    }

    /**
     * This method returns information about the given table name
     */
    private function tablesInformation() {
        // Launch the query to find information about tables
        // of the database
        $sQueryTables = "SELECT * FROM sqlite_master WHERE type='table'";
        $uResult = $this->database->query($sQueryTables);

        // Fetching result and preparing formatting of the result to a
        // convenient usable format.
        $aResult = array();
        while ($aRow = $uResult->fetchArray(SQLITE3_ASSOC)) {
            $aResult[] = $aRow;
        }

        return $aResult;
    }

    private function schemaInformation() {
        $aSchema = array();
        $aTables = $this->tablesInformation();
        foreach ($aTables as $aTableInformation) {
            if (!isset($aTableInformation['name'])) {
                throw new Exception();
            }

            $sTableName = $aTableInformation['name'];
            $aColumns = $this->columnsInformationWithTableName($sTableName);
            $aSchema[$sTableName] = $aColumns;

            unset($sTableName);
        }
        unset($aTables);
        return $aSchema;
    }

    private function dataInformation($sTableName) {

        $sQueryData = "SELECT * FROM " .$sTableName;
        $uResult = $this->database->query($sQueryData);

        // Fetching result and preparing formatting of the result to a
        // convenient usable format.
        $aResult = array();
        while ($aRow = $uResult->fetchArray(SQLITE3_ASSOC)) {
            $aResult[] = $aRow;
        }

        return $aResult;
    }

    /**
     * Main method that will export the SQLite Database to a JSON stirng format.
     */
    public function getJSONFromSQLite() {
        $aData = array();
        $aTables = $this->schemaInformation();
        foreach($aTables as $sTableName => $aColumns) {
            $aRows = $this->dataInformation($sTableName);
            $aData[$sTableName] = $aRows;
        }

        return $aData;
    }
}
