<?php
class SppMarkMasterController extends AppController {
	var $name = "SppMarkMaster";
	var $uses = array("SppMarkMaster");

	var $components = array('RequestHandler','Session');

	function beforeFilter()
	{
		parent::beforeFilter();
		$this->Auth->allow('index');
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
		// Load config file
		Configure::load('settings');
	}

	function index() {

		$time_for_mark = "";
		$mark_for_incorrect = "";
		$mark_for_correct = "";
		$mark_for_question = "";
		$mark_for_correction = "";
		$mark_for_start_app = "";
		try{
			if($this->RequestHandler->isPost()){
				if(isset($this->data)) {
					if(!$this->checkEmptyWithoutZero($this->data['SppMarkMaster']['time_for_mark']) &&
					!$this->checkEmptyWithoutZero($this->data['SppMarkMaster']['mark_for_incorrect']) &&
					!$this->checkEmptyWithoutZero($this->data['SppMarkMaster']['mark_for_correct']) &&
					!$this->checkEmptyWithoutZero($this->data['SppMarkMaster']['mark_for_question']) &&
					!$this->checkEmptyWithoutZero($this->data['SppMarkMaster']['mark_for_correction']) &&
					!$this->checkEmptyWithoutZero($this->data['SppMarkMaster']['mark_for_start_app'])
					)
					{
						$markdata = $this->SppMarkMaster->find('first');
						if(!empty($markdata)){

							$markdata['SppMarkMaster']['time_for_mark'] = $this->data['SppMarkMaster']['time_for_mark'];
							$markdata['SppMarkMaster']['mark_for_incorrect'] = $this->data['SppMarkMaster']['mark_for_incorrect'];
							$markdata['SppMarkMaster']['mark_for_correct'] = $this->data['SppMarkMaster']['mark_for_correct'];
							$markdata['SppMarkMaster']['mark_for_question'] = $this->data['SppMarkMaster']['mark_for_question'];
							$markdata['SppMarkMaster']['mark_for_correction'] = $this->data['SppMarkMaster']['mark_for_correction'];
							$markdata['SppMarkMaster']['mark_for_start_app'] = $this->data['SppMarkMaster']['mark_for_start_app'];

							if($this->SppMarkMaster->save($markdata)){
								$this->Session->setFlash(Configure::read('Message.UPDATE_SUCCESS'));
							}

						} else {
							// insert data

							$new_mask = array(
								'SppMarkMaster' => array(
										'time_for_mark' => $this->data['SppMarkMaster']['time_for_mark'],
										'mark_for_incorrect' => $this->data['SppMarkMaster']['mark_for_incorrect'],
										'mark_for_correct' => $this->data['SppMarkMaster']['mark_for_correct'],
										'mark_for_question' => $this->data['SppMarkMaster']['mark_for_question'],
										'mark_for_correction' => $this->data['SppMarkMaster']['mark_for_correction'],
										'mark_for_start_app' => $this->data['SppMarkMaster']['mark_for_start_app']
							)
							);
							$this-> SppMarkMaster-> save($new_mask);
							$this->Session->setFlash(Configure::read('Message.INSERT_SUCCESS'));
						}
							
					}
					else {
						$this->Session->setFlash(Configure::read('Message.ERR_MISSING_ITEM'));
					}
					$time_for_mark = $this->data['SppMarkMaster']['time_for_mark'];
					$mark_for_incorrect = $this->data['SppMarkMaster']['mark_for_incorrect'];
					$mark_for_correct = $this->data['SppMarkMaster']['mark_for_correct'];
					$mark_for_question = $this->data['SppMarkMaster']['mark_for_question'];
					$mark_for_correction = $this->data['SppMarkMaster']['mark_for_correction'];
					$mark_for_start_app = $this->data['SppMarkMaster']['mark_for_start_app'];
				}
			}
			else
			{
				$markdata = $this->SppMarkMaster->find('first');
				if(!empty($markdata)){
					$time_for_mark = $markdata['SppMarkMaster']['time_for_mark'];
					$mark_for_incorrect = $markdata['SppMarkMaster']['mark_for_incorrect'];
					$mark_for_correct = $markdata['SppMarkMaster']['mark_for_correct'];
					$mark_for_question = $markdata['SppMarkMaster']['mark_for_question'];
					$mark_for_correction = $markdata['SppMarkMaster']['mark_for_correction'];
					$mark_for_start_app = $markdata['SppMarkMaster']['mark_for_start_app'];
				}
			}
		}catch(Exception $e){
			$this->Session->setFlash(Configure::read('Message.ERR_EXCEPTION'));
		}

		$this->set('time_for_mark', $time_for_mark);
		$this->set('mark_for_incorrect', $mark_for_incorrect);
		$this->set('mark_for_correct', $mark_for_correct);
		$this->set('mark_for_question', $mark_for_question);
		$this->set('mark_for_correction', $mark_for_correction);
		$this->set('mark_for_start_app', $mark_for_start_app);
	}
}