import config from './config.js';
import _db     from './db.js';
import Dexie from "dexie";

export default class IndexDB_Cl {
    getTableSize (db, dbName){
        return new Promise((resolve,reject) => {
            if (db == null) {
                return reject();
            }
            var size = 0;
            db = event.target.result;
            var transaction = db.transaction([dbName])
                .objectStore(dbName)
                .openCursor();

            transaction.onsuccess = function(event){
                var cursor = event.target.result;
                if(cursor){
                    var storedObject = cursor.value;
                    var json = JSON.stringify(storedObject);
                    size += json.length;
                    cursor.continue();
                }
                else{
                    resolve(size);
                }
            }.bind(this);
            transaction.onerror = function(err){
                reject("error in " + dbName + ": " + err);
            }
        });
    };

    getDatabaseSize(dbName) {
        var request = Dexie.exists(config.DATE_NAME).then(function(exists) {
            if (exists){
                 return indexedDB.open(dbName);
            } else {
                return _db.open(dbName);
            }
        });

        var db;
        var dbSize = 0;
        request.onerror = function(event) {
            alert("Why didn't you allow my web app to use IndexedDB?!");
        };

        request.onsuccess = function(event) {
            db = event.target.result;
            var tableNames = [ ...db.objectStoreNames ];
            (function(tableNames, db) {
                var tableSizeGetters = tableNames
                    .reduce( (acc, tableName) => {
                        acc.push(this.getTableSize(db, tableName) );
                        return acc;
                    }, []);

                Promise.all(tableSizeGetters)
                    .then(sizes => {
                        console.log('--------- ' + db.name + ' -------------');
                        tableNames.forEach( (tableName,i) => {
                            console.log(" - " + tableName + "\t: " + this.humanReadableSize(sizes[i]));
                        });
                        var total = sizes.reduce(function(acc, val) {
                            return acc + val;
                        }, 0);

                        console.log("TOTAL: " + this.humanReadableSize(total))
                    });
            })(tableNames, db);
        };
    };

    humanReadableSize (bytes) {
        var thresh = 1024;
        if(Math.abs(bytes) < thresh) {
            return bytes + ' B';
        }
        var units = ['KB','MB','GB','TB','PB','EB','ZB','YB'];
        var u = -1;
        do {
            bytes /= thresh;
            ++u;
        } while(Math.abs(bytes) >= thresh && u < units.length - 1);
        return bytes.toFixed(1)+' '+units[u];
    }

    printIndexDBSizes() {
        _db.webkitGetDatabaseNames().onsuccess = function (e) {
            var databaseNames = e.target.result;
            var dbName;
            for(var i=0; i < databaseNames.length; i++) {
                dbName = databaseNames.item(i);
                this.getDatabaseSize(dbName);
            }
        };
    }

    // printIndexDBSizes();
}