/**
 * @ref https://github.com/matthewmueller/number-to-letter
 */
export default function(number, options) {
    var alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    var base     = alphabet.length;
    var digits   = [];
    var chars    = [];

    number = parseInt(number);

    do {
        var v = number % base;
        digits.push(v);
        number = Math.floor(number / base);
    } while (number-- > 0);

    while (digits.length) {
        chars.push(alphabet[digits.pop() - 1]);
    }

    return chars.join('');
}