<?php
define("SEPARATE_KEY", "|");
class SppCalendarContentController extends AppController
{
    var $name = 'SppCalendarContent';
    var $helpers = array('Html', 'Form', 'Session', 'Form', 'Dialog', 'pass4v');
    var $uses = array('SppCalendarContent');
    var $components = array('RequestHandler', 'Auth', 'Session', 'Pass4v');
	var $paginate = array();
	
    function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('add', 'index', 'edit');
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
    }


    function index()
    {
        if(isset($this->params['url']['delid'])){
        	$delid = $this->params['url']['delid'];
        	if($delid != ""){
        		$calendar_content = $this->SppCalendarContent->findById($delid);
        		$this->SppCalendarContent->delete($delid,true);
        		$this->Session->setFlash(Configure::read('Message.DELETE_SUCCESS'));
        		return $this->redirect(array('action' => 'index'));
			}
        }
        $created_date_from = '';
        $created_date_to = '';
        $title = '';
        $conditions = array();
        if ($this->RequestHandler->isPost()){
        	if(isset($this->data['submit_search'])){
				$created_date_from = $this->data['SppCalendarContent']['created_date_from'];
				$created_date_to = $this->data['SppCalendarContent']['created_date_to'];
				$title = $this->data['SppCalendarContent']['title'];
        	}
			
			$this->Session->write('calendarContent.date_from', $created_date_from);
			$this->Session->write('calendarContent.date_to', $created_date_to);
			$this->Session->write('calendarContent.title', $title);
        } else {
        	$created_date_from = $this->Session->read('calendarContent.date_from');
        	$created_date_to = $this->Session->read('calendarContent.date_to');
        	$title = $this->Session->read('calendarContent.title');
        }
        
        if(!empty($created_date_from)){
        	$conditions[] = "created_date >= '".date("Y-m-d", strtotime($created_date_from))."'";
        }
        if(!empty($created_date_to)){
        	$conditions[] = "created_date <= '".date("Y-m-d", strtotime($created_date_to))."'";
        }
        if(!empty($title)){
        	$conditions[] = "title LIKE '%".$title."%'";
        }
		
        $this->paginate = array(
        			'fields' => array('id', 'created_date', 'sort_order', 'title', 'is_free', 'is_public', 'reservation_flag'),
        			'conditions' => $conditions,
				    'limit' => Configure::read('CALENDAR.NUMBER_OF_PAGE'),
					'order' => array('SppCalendarContent.created_date' =>'desc', 'sort_order' => 'asc'));
        $calendar_contents = $this->paginate('SppCalendarContent');
        $this->set(compact('calendar_contents'));
        $this->set(compact('created_date_from'));
        $this->set(compact('created_date_to'));
        $this->set(compact('title'));
    }

    function add()
    {
    	$calendarContent = array();
    	if ($this->RequestHandler->isPost()){
    		$calendarContent['SppCalendarContent'] = $this->data['SppCalendarContent'];
    		$calendarContent['SppCalendarContent']['created_date'] = date("Y-m-d", strtotime($this->data['SppCalendarContent']['created_date']));
    		if (empty($this->data['title_icon']) || !is_uploaded_file($this->data['title_icon']['tmp_name'])) {
    			$this->Session->setFlash(Configure::read('Message.ERR_MISSING_CALENDAR_TITLE_ICON_IMAGE'));
				$this->set(compact('calendarContent'));
    			return;
    		}
    		$is_error = false;
    		$current_time = date('Ymdhis', time());
    		$uploads_dir = Configure::read('IMG_CALENDAR_CONTENT');
    		if ( ! is_dir($uploads_dir)) {
    			mkdir($uploads_dir);
    		}
    		if (!empty($this->data['title_icon']) &&
    			is_uploaded_file($this->data['title_icon']['tmp_name'])) {
    			$path_parts = pathinfo($this->data['title_icon']['name']);
				$full_path = $uploads_dir.$current_time.".".$path_parts['extension'];
				if(move_uploaded_file($this->data['title_icon']['tmp_name'], $full_path)){
					$calendarContent['SppCalendarContent']['title_icon'] = '../'.$full_path;
				} else {
					$is_error = true;
				}
    		}
    		/*if (!$is_error) {
    			if (!empty($this->data['body_image'])) {
		    		$body_images = '';
    				foreach ($this->data['body_image'] as $key => $body_image) {
    					if(is_uploaded_file($body_image['tmp_name'])) {
    						$path_parts = pathinfo($body_image['name']);
							$full_path = $uploads_dir.$path_parts['basename'];
							if(move_uploaded_file($body_image['tmp_name'], $full_path)){
								if(!empty($body_images)) {
									$body_images = $body_images.SEPARATE_KEY;
								}
								$body_images = $body_images.$full_path;
							} else {
								$is_error = true;
								break;
							}
    					}
    				}
    				$calendarContent['SppCalendarContent']['body_images'] = $body_images;
    			}
    		}*/
    		if (!$is_error && $this->SppCalendarContent->save($calendarContent)) {
    			$this->Session->setFlash(Configure::read('Message.ADD_SUCCESS'));
    			$this->set(compact('calendarContent'));
	    		return $this->redirect(array('action' => 'index'));
    		} else {
    			$this->Session->setFlash(Configure::read('Message.ERR_ADD'));
    		}
    	} else {
    		$calendarContent = $this->SppCalendarContent->create();
	    	$calendarContent['SppCalendarContent']['created_date'] = date('Y/m/d');
	    	$calendarContent['SppCalendarContent']['sort_order'] = 1;
	    	$calendarContent['SppCalendarContent']['title'] = '';
	    	$calendarContent['SppCalendarContent']['body_content'] = '';
    		
    	}
	    $this->set(compact('calendarContent'));
    }

    function edit()
    {
    	if(isset($this->params['url']['id'])){
    		$id = $this->params['url']['id'];
    		$calendarContent = $this->SppCalendarContent->findById($id);
    		if(empty($calendarContent)){
    			$this->render('/elements/error');
    		}
    	} else {
    		$this->render('/elements/error');
    	}
			
    	if ($this->RequestHandler->isPost()){
    		$title_icon = $calendarContent['SppCalendarContent']['title_icon'];
    		$uploads_dir = Configure::read('IMG_CALENDAR_CONTENT');
    		$current_time = date('Ymdhis', time());
    		$calendarContent['SppCalendarContent'] = $this->data['SppCalendarContent'];
    		$calendarContent['SppCalendarContent']['created_date'] = date("Y-m-d", strtotime($this->data['SppCalendarContent']['created_date']));
    		$is_error = false;
    		if (!empty($this->data['title_icon']) &&
    			is_uploaded_file($this->data['title_icon']['tmp_name'])) {
    			if(file_exists($title_icon)) {
	    			unlink($title_icon);
    			}
    			$path_parts = pathinfo($this->data['title_icon']['name']);
				$full_path = $uploads_dir.$current_time.".".$path_parts['extension'];
				if(move_uploaded_file($this->data['title_icon']['tmp_name'], $full_path)){
					$calendarContent['SppCalendarContent']['title_icon'] = '../'.$full_path;
				} else {
					$is_error = true;
				}
    		}
    		if (!$is_error && $this->SppCalendarContent->save($calendarContent)) {
    			$this->Session->setFlash(Configure::read('Message.EDIT_SUCCESS'));
    			$this->set(compact('calendarContent'));
	    		return $this->redirect(array('action' => 'index'));
    		} else {
    			$this->Session->setFlash(Configure::read('Message.ERR_EDIT'));
    		}
    	}
    	$this->set(compact('calendarContent'));
    }
}

?>
