<?php
define("LEARNER_ID", "学習者ＩＤ");
define("LEARNER_LAST_NAME", "氏名（姓）");
define("LEARNER_FIRST_NAME", "氏名（名）");
define("LEARNER_LAST_NAME_KANA", "氏名かな（姓）");
define("LEARNER_FIRST_NAME_KANA", "氏名かな（名）");
define("NICKNAME", "ニックネーム");
define("LEARNER_EMAIL", "メールアドレス");
define("POSTAL_CODE", "郵便番号");
define("ZONE", "都道府県");
define("ADDRESS", "住所１");
define("ADDRESS_DETAIL", "住所２");
define("ORGANIZATION_CODE", "利用コード");
define("ORGANIZATION_NAME", "団体名");
define("PAYMENT_STATUS", "入金ステータス");
define("CLASSIFICATION_NAME", "ユーザ区分");
define("CREATED_DATE", "申込日");
define("UPDATE_DATE", "更新日");
class SppLearnerController extends AppController {
	var $name = "SppLearner";
	var $uses = array("SppLearner","SppLicenseContent","SppOrganization","SppOrganizationContent",
					  "SppLicense","SppLearnerClassification","SppPaymentStatus");
	var $components = array('RequestHandler','Session', 'Csv', 'Pass4v');
	var $helpers = array('Html', 'Form');
	var $paginate = array();
	function beforeFilter()
	{
		parent::beforeFilter();
		$this->Auth->allow('index','edit','exportCSV','add','checkOrganizationExist',
		'getOrganizationName','delete','registrationConfirm', 'csvImport','add_web',
		'registrationHojinConfirm', 'add_connect_license');
	}
	function beforeRender() {
		parent::beforeRender();
	}

	function index(){
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
		$created_date_from = "";
		$created_date_to = "";
		$learner_id = "";
		$first_name = "";
		$last_name = "";
		$learner_email = "";
		$learner_organization_code = "";
		$learner_payment_status_id = "";
		$learner_classification_id = Configure::read('LEARNER_CLASSIFICATION.GENERAL');
		if ($this->RequestHandler->isPost()){
			$this->Session->delete('Search.searchkey');
			$search_key = array();
			if(!empty($this->data['SppLearner']['created_date_from'])){
				$created_date_from = DateTime::createFromFormat('Y/m/d H:i:s', $this->data['SppLearner']['created_date_from']." 00:00:00");
				$search_key['SppLearner']['created_date_from'] = $created_date_from;
			}

			if(!empty($this->data['SppLearner']['created_date_to'])){
				$created_date_to = DateTime::createFromFormat('Y/m/d H:i:s',$this->data['SppLearner']['created_date_to']." 23:59:59");
				$search_key['SppLearner']['created_date_to'] = $created_date_to;
			}

			if(!empty($this->data['SppLearner']['id'])){
				$learner_id = trim($this->data['SppLearner']['id']);
				$search_key['SppLearner']['learner_id'] = $learner_id;
			}

			if(!empty($this->data['SppLearner']['first_name'])){
				$first_name = trim($this->data['SppLearner']['first_name']);
				$search_key['SppLearner']['first_name'] = $first_name;
			}

			if(!empty($this->data['SppLearner']['last_name'])){
				$last_name = trim($this->data['SppLearner']['last_name']);
				$search_key['SppLearner']['last_name'] = $last_name;
			}

			if(!empty($this->data['SppLearner']['email'])){
				$learner_email = trim($this->data['SppLearner']['email']);
				$search_key['SppLearner']['learner_email'] = $learner_email;
			}

			if(!empty($this->data['SppLearner']['organization_code'])){
				$learner_organization_code = trim($this->data['SppLearner']['organization_code']);
				$search_key['SppLearner']['learner_organization_code'] = $learner_organization_code;
			}

			if(!empty($this->data['SppLearner']['payment_status_id'])){
				$learner_payment_status_id = $this->data['SppLearner']['payment_status_id'];
				$search_key['SppLearner']['learner_payment_status_id'] = $learner_payment_status_id;
			}

			if(!empty($this->data['SppLearner']['learner_classification_id'])){
				$learner_classification_id = trim($this->data['SppLearner']['learner_classification_id']);
			} else {
				$learner_classification_id = "";
			}
			$search_key['SppLearner']['learner_classification_id'] = $learner_classification_id;
			$this->Session->write('Search.searchkey', $search_key);
			if(isset($this->data['submit_csv_output'])){
				$this->exportCSV($_POST['encode']);
			}

		} else {
			$search_key = $this->Session->read('Search.searchkey');
			if(!empty($search_key)){
				if(!empty($search_key['SppLearner']['created_date_from'])){
					$created_date_from = $search_key['SppLearner']['created_date_from'];
				}

				if(!empty($search_key['SppLearner']['created_date_to'])){
					$created_date_to = $search_key['SppLearner']['created_date_to'];
				}

				if(!empty($search_key['SppLearner']['learner_id'])){
					$learner_id = $search_key['SppLearner']['learner_id'];
				}

				if(!empty($search_key['SppLearner']['first_name'])){
					$first_name = $search_key['SppLearner']['first_name'];
				}

				if(!empty($search_key['SppLearner']['last_name'])){
					$last_name = $search_key['SppLearner']['last_name'];
				}

				if(!empty($search_key['SppLearner']['learner_email'])){
					$learner_email = $search_key['SppLearner']['learner_email'];
				}

				if(isset($search_key['SppLearner']['learner_organization_code'])){
					$learner_organization_code = $search_key['SppLearner']['learner_organization_code'];
				}

				if(isset($search_key['SppLearner']['learner_payment_status_id'])){
					$learner_payment_status_id = $search_key['SppLearner']['learner_payment_status_id'];
				}

				if(isset($search_key['SppLearner']['learner_classification_id'])){
					$learner_classification_id = $search_key['SppLearner']['learner_classification_id'];
				}
			}
		}
		$this->paginate = $this->SppLearner->getListLearner($created_date_from, $created_date_to, $learner_id, $first_name, $last_name,
		$learner_email, $learner_organization_code, $learner_payment_status_id, $learner_classification_id);
		$learners = $this->paginate('SppLearner', 2);

		$organizations = $this->SppOrganization->find('all',array('fields'=>'CONCAT(code_large,code_middle,code_small) AS code, organization_name'));
		$payment_statuses = $this->SppPaymentStatus->find('all');
		$learner_classifications = $this->SppLearnerClassification->find('all');
		$this->set('learners', $learners);
		$this->set('organizations', $organizations);
		$this->set('payment_statuses', $payment_statuses);
		$this->set('learner_classifications', $learner_classifications);
		$this->set('created_date_from', empty($created_date_from)? '':$created_date_from->format('Y/m/d'));
		$this->set('created_date_to', empty($created_date_to)?'':$created_date_to->format('Y/m/d'));
		$this->set('learner_id', $learner_id);
		$this->set('first_name', $first_name);
		$this->set('last_name', $last_name);
		$this->set('learner_email', $learner_email);
		$this->set('learner_organization_code', $learner_organization_code);
		$this->set('learner_payment_status_id', $learner_payment_status_id);
		$this->set('learner_classification_id', $learner_classification_id);
	}

	function edit(){
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
		if ($this->RequestHandler->isPost()){
			$learner_id = $this->data['SppLearner']['id'];
			$learner_edit = $this->SppLearner->getListLearnerById($learner_id);
			if(!empty($learner_edit)){
				$is_error = false;
				if(empty($this->data['SppLearner']['email'])){
					$this->Session->setFlash(Configure::read('Message.EMAIL_REQUIRED'));
					$is_error = true;
				} else {
					$learner = $this->SppLearner->find('first',array('conditions' => array('SppLearner.email' => $this->data['SppLearner']['email'],'id <>'=> $learner_id)));
					if(!empty($learner)){
						$this->Session->setFlash(Configure::read('Message.EMAIL_EXISTED'));
						$is_error = true;
					}
				}

				/*if(!$is_error && (empty($this->data['SppLearner']['first_name']) || empty($this->data['SppLearner']['last_name']))){
					$this->Session->setFlash(Configure::read('Message.NAME_REQUIRED'));
					$is_error = true;
					}

					if(!$is_error && (empty($this->data['SppLearner']['first_name_kana']) || empty($this->data['SppLearner']['last_name_kana']))){

					$this->Session->setFlash(Configure::read('Message.NAME_KANA_REQUIRED'));
					$is_error = true;
					}*/

				$learner_edit['SppLearner']['email'] = $this->data['SppLearner']['email'];
				$learner_edit['SppLearner']['first_name'] = $this->data['SppLearner']['first_name'];
				$learner_edit['SppLearner']['last_name'] = $this->data['SppLearner']['last_name'];
				$learner_edit['SppLearner']['first_name_kana'] = $this->data['SppLearner']['first_name_kana'];
				$learner_edit['SppLearner']['last_name_kana'] = $this->data['SppLearner']['last_name_kana'];
				$learner_edit['SppLearner']['nickname'] = $this->data['SppLearner']['nickname'];
				//$learner_edit['SppLearner']['organization_code'] = $this->data['SppLearner']['organization_code'];
				$learner_edit['SppLearner']['payment_status_id'] = $this->data['SppLearner']['payment_status_id'];
				$learner_edit['SppLearner']['learner_classification_id'] = $this->data['SppLearner']['learner_classification_id'];
				if(Configure::read('LEARNER.SHOW_ADDRESS') == 1){
					$learner_edit['SppLearner']['postal_code'] = $this->data['SppLearner']['postal_code'];
					$learner_edit['SppLearner']['zone'] = $this->data['SppLearner']['zone'];
					$learner_edit['SppLearner']['address'] = $this->data['SppLearner']['address'];
					$learner_edit['SppLearner']['address_detail'] = $this->data['SppLearner']['address_detail'];
						
				}
				if(!$is_error){
					$learner_edit['SppLearner']['updated_datetime'] = date('Y-m-d H:i:s');
					$result = $this->SppLearner->save($learner_edit,array('conditions'=>array('SppLearner.id' => $learner_id)));
					if($result){
						$this->Session->setFlash(Configure::read('Message.EDIT_SUCCESS'));
						//$learner_edit = $this->SppLearner->getListLearnerById($learner_id);
						return $this->redirect(array('action' => 'index'));
					} else {
						$this->Session->setFlash(Configure::read('Message.EDIT_ERROR'));
					}
				}
				$this->set('learner',$learner_edit);
			}
		} else {
			if(isset($this->params['url']['id'])){
				$learner_id = $this->params['url']['id'];
				$learner = $this->SppLearner->getListLearnerById($learner_id);
				if(empty($learner)){
					$this->render('/elements/error');
				}
				$this->set('learner',$learner);
			} else {
				$this->render('/elements/error');
			}
		}
		//$organizations = $this->SppOrganization->find('all',array('fields'=>'CONCAT(code_large,code_middle,code_small) AS code'));
		$payment_statuses = $this->SppPaymentStatus->find('all');
		$learner_classifications = $this->SppLearnerClassification->find('all');
		//$this->set('organizations', $organizations);
		$this->set('payment_statuses', $payment_statuses);
		$this->set('learner_classifications', $learner_classifications);
	}

	/**
	 * delete learner
	 */
	function delete(){
		try{
			if(isset($this->params['url']['id'])){
				$this->SppLearner->begin();
				$learner_id = $this->params['url']['id'];
				$learner = $this->SppLearner->find('first',array('conditions' => array('id'=> $learner_id)));
				$orgCode = $learner['SppLearner']['organization_code'];
				$is_pesonal_code = $organization_code == Configure::read('PERSONAL_CODE') ;
				if(!$is_pesonal_code){
					$organization = $this->SppOrganization->find('first',array('conditions' => array('CONCAT(code_large,code_middle,code_small)'=>$orgCode)));
					if($organization != null){
						$organization['SppOrganization']['registration_no'] = $organization['SppOrganization']['registration_no'] - 1;
						$this->SppOrganization->save($organization);
					}
				}
				$this->SppLearner->delete($learner_id);
				// remove quiz_logs
				$this->loadModel('SppQuizLog');
				$this->SppQuizLog->deleteAll(array('learner_id' => $learner_id));
				// remove learning_logs
				$this->loadModel('SppLearningLog');
				$this->SppLearningLog->deleteAll(array('learner_id' => $learner_id));
				// remove study records
				$this->loadModel('SppStudyRecord');
				$this->SppStudyRecord->deleteAll(array('learner_id' => $learner_id));
				// remove last week study record
				$this->loadModel('SppLastWeekLearningRecord');
				$this->SppLastWeekLearningRecord->deleteAll(array('learner_id' => $learner_id));
				// remove question
				$this->loadModel('SppQuestion');
				$this->SppQuestion->deleteAll(array('learner_id' => $learner_id));
				// remove correction
				$this->loadModel('SppCorrection');
				$this->SppCorrection->deleteAll(array('learner_id' => $learner_id));
				// remove license
				$this->loadModel('SppLicense');
				$this->loadModel('SppLicenseContent');
				$licenses = $this->SppLicense->find('all',array('conditions' => array('learner_id' => $learner_id)));
				if(!empty($licenses)){
					foreach ($licenses as $license){
						$this->SppLicenseContent->deleteAll(array('license_id' => $license['SppLicense']['id']));
					}
					$this->SppLicense->deleteAll(array('learner_id' => $learner_id));
				}

				$this->SppLearner->commit();
			}
		}catch(Exception $e){
			$this->SppLearner->rollBack();
		}
		return $this->redirect(array('action' => 'index'));
	}

	function exportCSV($encode){
		$this->layout = false;
		$learners = $this->SppLearner->getAllForCSV();
		$array = array();
		//edit array
		if(!empty($learners)){
			// export 住所 data if show address confit == 1
			if(Configure::read('LEARNER.SHOW_ADDRESS') == 1){
				foreach ($learners as $learner) {
					$temp = array(
					$learner['SppLearner']['id'],
					$learner['SppLearner']['first_name'],
					$learner['SppLearner']['last_name'],
					$learner['SppLearner']['first_name_kana'],
					$learner['SppLearner']['last_name_kana'],
					$learner['SppLearner']['nickname'],
					$learner['SppLearner']['email'],
					$learner['SppLearner']['postal_code'],
					$learner['SppLearner']['zone'],
					$learner['SppLearner']['address'],
					$learner['SppLearner']['address_detail'],
					$learner['SppLearner']['organization_code'],
					$learner['SppOrganization']['organization_name'],
					$learner['SppPaymentStatus']['payment_status_name'],
					$learner['SppLearnerClassification']['classification_name'],
					(!empty($learner['SppLearner']['created_datetime'])) ? date('Y/m/d', strtotime($learner['SppLearner']['created_datetime'])) : '',
					(!empty($learner['SppLearner']['updated_datetime'])) ? date('Y/m/d', strtotime($learner['SppLearner']['updated_datetime'])) : ''
					);
					array_push($array, $temp);
				}
			} else {
				foreach ($learners as $learner) {
					$temp = array(
					$learner['SppLearner']['id'],
					$learner['SppLearner']['first_name'],
					$learner['SppLearner']['last_name'],
					$learner['SppLearner']['first_name_kana'],
					$learner['SppLearner']['last_name_kana'],
					$learner['SppLearner']['nickname'],
					$learner['SppLearner']['email'],
					$learner['SppLearner']['organization_code'],
					$learner['SppOrganization']['organization_name'],
					$learner['SppPaymentStatus']['payment_status_name'],
					$learner['SppLearnerClassification']['classification_name'],
					(!empty($learner['SppLearner']['created_datetime'])) ? date('Y/m/d', strtotime($learner['SppLearner']['created_datetime'])) : '',
					(!empty($learner['SppLearner']['updated_datetime'])) ? date('Y/m/d', strtotime($learner['SppLearner']['updated_datetime'])) : ''
					);
					array_push($array, $temp);
				}
			}
		}
		if(Configure::read('LEARNER.SHOW_ADDRESS') == 1){
			$header = array(LEARNER_ID, LEARNER_LAST_NAME, LEARNER_FIRST_NAME, LEARNER_LAST_NAME_KANA,
			LEARNER_FIRST_NAME_KANA, NICKNAME, LEARNER_EMAIL, POSTAL_CODE, ZONE, ADDRESS, ADDRESS_DETAIL,
			ORGANIZATION_CODE, ORGANIZATION_NAME, PAYMENT_STATUS, CLASSIFICATION_NAME, CREATED_DATE, UPDATE_DATE);
		} else {
			$header = array(LEARNER_ID, LEARNER_LAST_NAME, LEARNER_FIRST_NAME, LEARNER_LAST_NAME_KANA,
			LEARNER_FIRST_NAME_KANA, NICKNAME, LEARNER_EMAIL, ORGANIZATION_CODE, ORGANIZATION_NAME,
			PAYMENT_STATUS, CLASSIFICATION_NAME, CREATED_DATE, UPDATE_DATE);
		}
		$fileName = '学習者'.date('Ymdhms');
		$this->Csv->export($encode, $array, $header, $fileName . '.csv');
	}

	function add(){
		$this->autoLayout = true;
		$is_smart_device = false;
		$iPhone = stripos($_SERVER['HTTP_USER_AGENT'],"iPhone");
		$Android = stripos($_SERVER['HTTP_USER_AGENT'],"Android");
		if($iPhone || $Android){
			$is_smart_device = true;
			$this->autoLayout = false;
		}
		$this->set('is_iphone', $iPhone);
		if(!$is_smart_device){
			// check session and role
			if(!$this->isSystemManagement()){
				$this->render('/elements/error');
				return;
			}
		}
		$postal_code = "";
		$zone = "";
		$address = "";
		$address_detail = "";
		$this->set ( 'is_smart_device', $is_smart_device );
		try{
			if ($this->RequestHandler->isPost()){
				$payment_status = Configure::read('PAYMENT_STATUS.UNPAID');
				$learn_id = "";
				$organization_code = trim($this->data['SppLearner']['organization_code']);
				$is_personal_paid = false;
				$is_generate_license = false;
				if(empty($organization_code)){
					$organization_code = Configure::read('PERSONAL_CODE');
				}
				// $is_pesonal_code = true when user input organization_code is 8998
				$is_pesonal_code = $organization_code == Configure::read('PERSONAL_CODE') ;
				if(!$is_pesonal_code){
					$organization = $this->SppOrganization->find('first',array('conditions' => array('CONCAT(code_large,code_middle,code_small)'=>$organization_code)));
					if(empty($organization)){
						$this->Session->setFlash(Configure::read('Message.ERR_ORGANIZATION_CODE_NOT_EXISTING'));
						return;
					}
					if($organization['SppOrganization']['allowed_registration_no'] <= $organization['SppOrganization']['registration_no']){
						$this->Session->setFlash(Configure::read('Message.ERR_REGISTRATION_EXCEED'));
						return;
					}
					$payment_method_id = $organization['SppOrganization']['payment_method_id'];
					// check 氏名/氏名かな/住所 required if payment_method is 個人払い/法人払い
					if($payment_method_id == Configure::read('PAYMENT_METHOD.PERSONAL') ||
					$payment_method_id == Configure::read('PAYMENT_METHOD.COMPANY')){
						if(empty($this->data['SppLearner']['first_name']) || empty($this->data['SppLearner']['last_name'])){
							$this->Session->setFlash(Configure::read('Message.NAME_REQUIRED'));
							return;
						}
							
						if(empty($this->data['SppLearner']['first_name_kana']) || empty($this->data['SppLearner']['last_name_kana'])){
							$this->Session->setFlash(Configure::read('Message.NAME_KANA_REQUIRED'));
							return;
						}
							
						// check 住所 required
						if(Configure::read('LEARNER.SHOW_ADDRESS') == 1){
							if(empty($this->data['SppLearner']['postal_code'])){
								$this->Session->setFlash(Configure::read('Message.POSTAL_CODE_REQUIRED'));
								return;
							}

							if(empty($this->data['SppLearner']['zone'])){
								$this->Session->setFlash(Configure::read('Message.ZONE_REQUIRED'));
								return;
							}

							if(empty($this->data['SppLearner']['address'])){
								$this->Session->setFlash(Configure::read('Message.ADDRESS_REQUIRED'));
								return;
							}

							if(empty($this->data['SppLearner']['address_detail'])){
								$this->Session->setFlash(Configure::read('Message.ADDRESS_DETAIL_REQUIRED'));
								return;
							}
							$postal_code = $this->data['SppLearner']['postal_code'];
							$zone = $this->data['SppLearner']['zone'];
							$address = $this->data['SppLearner']['address'];
							$address_detail = $this->data['SppLearner']['address_detail'];
						}
					}
					$payment_status = Configure::read('PAYMENT_STATUS.PAID');
					if($payment_method_id == Configure::read('PAYMENT_METHOD.PERSONAL')){
						$is_personal_paid = true;
					}
					$learn_id = $this->generalLearnerId($organization_code,$payment_method_id);
					$is_generate_license = $payment_method_id != Configure::read('PAYMENT_METHOD.STORE');
				} else {
					$learn_id = $this->generalLearnerId($organization_code,Configure::read('PAYMENT_METHOD.STORE'));
					$payment_status = Configure::read('PAYMENT_STATUS.PAID');
				}
				$error = false;
				if($this->SppLearner->checkEmailExisted(trim($this->data['SppLearner']['email']))){
					$this->Session->setFlash(Configure::read('Message.EMAIL_EXISTED'));
					return;
				}
				$this->SppLearner->begin();
				$this->SppOrganization->begin();
				$this->SppOrganizationContent->begin();
				$this->SppLicense->begin();
				$this->SppLicenseContent->begin();
				if(!empty($learn_id)){
					$learner_classification_id = Configure::read('LEARNER_CLASSIFICATION.GENERAL');
					/*if($is_personal_paid){
						$learner_classification_id = Configure::read('LEARNER_CLASSIFICATION.BLOCK');
						}*/
					// insert new spp learner
					$this->SppLearner->set(array(
					'id' => $learn_id,
					'first_name' => $this->data['SppLearner']['first_name'],
					'last_name' => $this->data['SppLearner']['last_name'],
					'first_name_kana' => $this->data['SppLearner']['first_name_kana'],
					'last_name_kana' => $this->data['SppLearner']['last_name_kana'],
					'nickname' => $this->data['SppLearner']['nickname'],
					'email' => $this->data['SppLearner']['email'],
					'password' => $this->data['SppLearner']['password'],
					'organization_code' => $organization_code,
					'payment_status_id' => $payment_status,
					'learner_classification_id' => $learner_classification_id,
					'postal_code' => $postal_code,
					'zone' => $zone,
					'address' => $address,
					'address_detail' => $address_detail,
					'created_datetime' =>  date('Y-m-d H:i:s'),
					'updated_datetime' => date('Y-m-d H:i:s'),
					));
					if(!$this->SppLearner->save()){
						$error = true;
					}
					// increase registration_no to +1 for SppOrganization
					if(!$is_pesonal_code && !$error){
						$organization['SppOrganization']['registration_no'] += 1;
						if(!$this->SppOrganization->save($organization,array('conditions' => array('id'=>$organization['SppOrganization']['id'])))){
							$error = true;
						}
					}

					// generate spp_license
					if(!$error && $is_generate_license){
						$license_code = "";
						$temp_check = true;
						do{
							// generate license_code
							$license_code = $this->SppLicense->genRandomStringE();
							$temp_check = $this->SppLicense->checkLicenseCodeExit($license_code);
						} while($temp_check);
						$license_desc = $learn_id;
						if(!empty($this->data['SppLearner']['first_name'])){
							$license_desc = $license_desc." ".$this->data['SppLearner']['first_name'];
						}
						if(!empty($this->data['SppLearner']['last_name'])){
							$license_desc = $license_desc." ".$this->data['SppLearner']['last_name'];
						}
						$days_of_usage = $organization['SppOrganization']['days_of_usage'];
						$expired_start_date = date('Y-m-d');
						$expired_end_date = date('Y-m-d',strtotime("+".$days_of_usage." days"));
						$this->SppLicense->set(array(
						'license_code' => $license_code,
						'license_desc' => $license_desc,
						'expired_start_date' => $expired_start_date,
						'expired_end_date' => $expired_end_date,
						'comment' => Configure::read('LICENSE.DEFAULT_COMMENT'),
						'learner_id' => $learn_id,
						'creator_id' => Configure::read('UserID.SYSADMIN'),
						'created_datetime' => date('Y-m-d H:i:s'),
						'updated_datetime' => date('Y-m-d H:i:s'),
						'user_id' => Configure::read('UserID.SYSADMIN'),
						'check_flag' => $organization['SppOrganization']['certificate']
						));
						if(!$this->SppLicense->save()){
							$error = true;
						}
					}

					// save license_content
					if(!$error && $is_generate_license){
						$organization_contents = $this->SppOrganizationContent->find('all',array('conditions' => array('organization_id' => $organization['SppOrganization']['id'])));
						if(!empty($organization_contents)){
							$license_id = $this->SppLicense->getLastInsertId();
							foreach ($organization_contents as $item){
								$this->SppLicenseContent->create();
								$this->SppLicenseContent->set(array(
											'license_id' => $license_id,
											'content_id' => $item['SppOrganizationContent']['content_id']));
								if(!$this->SppLicenseContent->save()){
									$error = true;
									break;
								}
							}
						}
					}
					if(!$error){
						$this->SppLearner->commit();
						$this->SppOrganization->commit();
						$this->SppLicense->commit();
						$this->SppLicenseContent->commit();
						// redirect to registration confirm screen
						if($is_personal_paid){
							return $this->redirect(array('action' => 'registrationConfirm'));
						}
						$this->Session->setFlash(Configure::read('Message.INSERT_SUCCESS'));
						if(!$is_smart_device){
							return $this->redirect(array('action' => 'index'));
						}
					} else {
						$this->SppLearner->rollback();
						$this->SppOrganization->rollback();
						$this->SppLicense->rollback();
						$this->SppLicenseContent->rollback();
						$this->Session->setFlash(Configure::read('Message.INSERT_FAILURE'));
					}
				} else {
					// error message
					$this->Session->setFlash(Configure::read('Message.INSERT_FAILURE'));
					return;
				}
					
			}
		}catch(Exception $e){
			$this->SppLearner->rollback();
			$this->SppOrganization->rollback();
			$this->SppLicense->rollback();
			$this->SppLicenseContent->rollback();

			$this->Session->setFlash($e->getMessage());
		}
	}

	function add_connect_license(){
		$this->set('title_for_layout','ユーザ登録');
		$this->autoLayout = true;
		$is_smart_device = false;
		$iPhone = stripos($_SERVER['HTTP_USER_AGENT'],"iPhone");
		$Android = stripos($_SERVER['HTTP_USER_AGENT'],"Android");
		if($iPhone || $Android){
			$is_smart_device = true;
			$this->autoLayout = false;
		}
		if(!$is_smart_device) {
			if (!$this->isLoggedUser()) {
				$this->set ( 'err_msg', Configure::read('Message.ERR_CANNOT_DISPLAY_PAGE_PC') );
				$this->render('/elements/error_display_page');
				return;
			}
			// check session and role
			if(!$this->isSystemManagement()){
				$this->render('/elements/error');
				return;
			}
		}
		$this->set ( 'is_smart_device', $is_smart_device );
		try{
			if ($this->RequestHandler->isPost()){
				$payment_status = Configure::read('PAYMENT_STATUS.PAID');
				$learn_id = "";
				$organization_code = trim($this->data['SppLearner']['organization_code']);
				$is_personal_paid = false;
				$license_code = trim($this->data['SppLearner']['license_code']);
				if (!empty($license_code)) {
					$license = $this->SppLicense->findByLicenseCode($license_code);
					if(empty($license)) {
						$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_CODE_WRONG'));
						return;
					}
					if(!$this->SppLicense->checkLicenseValid($license)) {
						$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_CODE_WRONG'));
						return;
					}
				} else {
					$organization_code = Configure::read('PERSONAL_CODE');
					$payment_method_id = Configure::read('PAYMENT_METHOD.STORE');
				}
				$is_pesonal_code = $organization_code == Configure::read('PERSONAL_CODE') ;
				if (!$is_pesonal_code) {
					$organization = $this->SppOrganization->find('first',array('conditions' => array('CONCAT(code_large,code_middle,code_small)'=>$organization_code)));
					if(empty($organization)){
						$this->Session->setFlash(Configure::read('Message.ERR_ORGANIZATION_CODE_NOT_EXISTING'));
						return;
					}
						
					$payment_method_id = $organization['SppOrganization']['payment_method_id'];
					if($payment_method_id == Configure::read('PAYMENT_METHOD.PERSONAL')){
						$is_personal_paid = true;
					}
				}
				$learn_id = $this->generalLearnerId($organization_code,$payment_method_id);

				$error = false;
				if($this->SppLearner->checkEmailExisted(trim($this->data['SppLearner']['email']))){
					$this->Session->setFlash(Configure::read('Message.EMAIL_EXISTED'));
					return;
				}
				$this->SppLearner->begin();
				$this->SppLicense->begin();
				$this->SppLicenseContent->begin();
				if(!empty($learn_id)){
					$learner_classification_id = Configure::read('LEARNER_CLASSIFICATION.GENERAL');
					// insert new spp learner
					$this->SppLearner->set(array(
						'id' => $learn_id,
						'first_name' => '',
						'last_name' => '',
						'first_name_kana' => '',
						'last_name_kana' => '',
						'nickname' => $this->data['SppLearner']['nickname'],
						'email' => $this->data['SppLearner']['email'],
						'password' => $this->data['SppLearner']['password'],
						'organization_code' => $organization_code,
						'payment_status_id' => $payment_status,
						'learner_classification_id' => $learner_classification_id,
						'created_datetime' =>  date('Y-m-d H:i:s'),
						'updated_datetime' => date('Y-m-d H:i:s'),
					));
					if(!$this->SppLearner->save()){
						$error = true;
					}

					// update spp_license
					if(!$error && !empty($license)){
						$license_desc = $learn_id;
						if(!empty($this->data['SppLearner']['first_name'])){
							$license_desc = $license_desc." ".$this->data['SppLearner']['first_name'];
						}
						if(!empty($this->data['SppLearner']['last_name'])){
							$license_desc = $license_desc." ".$this->data['SppLearner']['last_name'];
						}
						$days_of_usage = $organization['SppOrganization']['days_of_usage'];
						$license['SppLicense']['license_desc'] = $license_desc;
						$license['SppLicense']['expired_start_date'] = date('Y-m-d');
						$license['SppLicense']['expired_end_date'] = date('Y-m-d',strtotime("+".$days_of_usage." days"));
						$license['SppLicense']['comment'] = Configure::read('LICENSE.DEFAULT_COMMENT');
						$license['SppLicense']['learner_id'] = $learn_id;
						$license['SppLicense']['client_used_date'] = date('Y-m-d');
						$license['SppLicense']['creator_id'] = Configure::read('UserID.SYSADMIN');
						$license['SppLicense']['updated_datetime'] = date('Y-m-d H:i:s');
						$license['SppLicense']['user_id'] = Configure::read('UserID.SYSADMIN');
						$license['SppLicense']['check_flag'] = $organization['SppOrganization']['certificate'];
						if(!$this->SppLicense->save($license)){
							$error = true;
						}
					}

					// save license_content
					if(!$error && !empty($license)){
						$organization_contents = $this->SppOrganizationContent->find('all',array('conditions' => array('organization_id' => $organization['SppOrganization']['id'])));
						if(!empty($organization_contents)){
							$license_id = $license['SppLicense']['id'];
							$this->SppLicenseContent->deleteAll(array('license_id' => $license_id), false);
							foreach ($organization_contents as $item){
								$this->SppLicenseContent->create();
								$this->SppLicenseContent->set(array(
											'license_id' => $license_id,
											'content_id' => $item['SppOrganizationContent']['content_id']));
								if(!$this->SppLicenseContent->save()){
									$error = true;
									break;
								}
							}
						}
					}
					if(!$error){
						$this->SppLearner->commit();
						$this->SppLicense->commit();
						$this->SppLicenseContent->commit();
						// redirect to registration confirm screen
						if($is_personal_paid){
							return $this->redirect(array('action' => 'registrationConfirm'));
						}
						$this->Session->setFlash(Configure::read('Message.INSERT_SUCCESS'));

					} else {
						$this->SppLearner->rollback();
						$this->SppLicense->rollback();
						$this->SppLicenseContent->rollback();
						$this->Session->setFlash(Configure::read('Message.INSERT_FAILURE'));
					}
				} else {
					// error message
					$this->Session->setFlash(Configure::read('Message.INSERT_FAILURE'));
					return;
				}
					
			}
		}catch(Exception $e){
			$this->SppLearner->rollback();
			$this->SppOrganization->rollback();
			$this->SppLicense->rollback();
			$this->SppLicenseContent->rollback();

			$this->Session->setFlash($e->getMessage());
		}
	}

	/**
	 *
	 * registering learner
	 */
	function add_web(){
		$this->autoLayout = true;
		$is_smart_device = false;
		$iPhone = stripos($_SERVER['HTTP_USER_AGENT'],"iPhone");
		$Android = stripos($_SERVER['HTTP_USER_AGENT'],"Android");
		if($iPhone || $Android){
			$is_smart_device = true;
			$this->autoLayout = false;
		}
		$this->set('is_iphone', $iPhone);
		if(!$is_smart_device){
			// check session and role
			if(!$this->isSystemManagement()){
				$this->render('/elements/error');
				return;
			}
		}
		$postal_code = "";
		$zone = "";
		$address = "";
		$address_detail = "";
		$this->set ( 'is_smart_device', $is_smart_device );
		try{
			if ($this->RequestHandler->isPost()){
				$payment_status = Configure::read('PAYMENT_STATUS.UNPAID');
				$learn_id = "";
				$organization_code = trim($this->data['SppLearner']['organization_code']);
				$is_generate_license = false;
				if(empty($organization_code)){
					$organization_code = Configure::read('PERSONAL_CODE');
				}
				// $is_pesonal_code = true when user input organization_code is 8998
				$is_pesonal_code = $organization_code == Configure::read('PERSONAL_CODE') ;
				if(!$is_pesonal_code){
					$organization = $this->SppOrganization->find('first',array('conditions' => array('CONCAT(code_large,code_middle,code_small)'=>$organization_code)));
					if(empty($organization)){
						$this->Session->setFlash(Configure::read('Message.ERR_ORGANIZATION_CODE_NOT_EXISTING'));
						return;
					}
					if($organization['SppOrganization']['allowed_registration_no'] <= $organization['SppOrganization']['registration_no']){
						$this->Session->setFlash(Configure::read('Message.ERR_REGISTRATION_EXCEED'));
						return;
					}
					$payment_method_id = $organization['SppOrganization']['payment_method_id'];
					// check 氏名/氏名かな/住所 required if payment_method is 個人払い/法人払い
					if($payment_method_id == Configure::read('PAYMENT_METHOD.PERSONAL') ||
					$payment_method_id == Configure::read('PAYMENT_METHOD.COMPANY')){
						if(empty($this->data['SppLearner']['first_name']) || empty($this->data['SppLearner']['last_name'])){
							$this->Session->setFlash(Configure::read('Message.NAME_REQUIRED'));
							return;
						}
							
						if(empty($this->data['SppLearner']['first_name_kana']) || empty($this->data['SppLearner']['last_name_kana'])){
							$this->Session->setFlash(Configure::read('Message.NAME_KANA_REQUIRED'));
							return;
						}
							
						// check 住所 required
						if(Configure::read('LEARNER.SHOW_ADDRESS') == 1){
							if(empty($this->data['SppLearner']['postal_code'])){
								$this->Session->setFlash(Configure::read('Message.POSTAL_CODE_REQUIRED'));
								return;
							}

							if(empty($this->data['SppLearner']['zone'])){
								$this->Session->setFlash(Configure::read('Message.ZONE_REQUIRED'));
								return;
							}

							if(empty($this->data['SppLearner']['address'])){
								$this->Session->setFlash(Configure::read('Message.ADDRESS_REQUIRED'));
								return;
							}

							if(empty($this->data['SppLearner']['address_detail'])){
								$this->Session->setFlash(Configure::read('Message.ADDRESS_DETAIL_REQUIRED'));
								return;
							}
							$postal_code = $this->data['SppLearner']['postal_code'];
							$zone = $this->data['SppLearner']['zone'];
							$address = $this->data['SppLearner']['address'];
							$address_detail = $this->data['SppLearner']['address_detail'];
						}
					}
					$payment_status = Configure::read('PAYMENT_STATUS.PAID');
					$learn_id = $this->generalLearnerId($organization_code,$payment_method_id);
					$is_generate_license = $payment_method_id != Configure::read('PAYMENT_METHOD.STORE');
				} else {
					$learn_id = $this->generalLearnerId($organization_code,Configure::read('PAYMENT_METHOD.STORE'));
					$payment_status = Configure::read('PAYMENT_STATUS.PAID');
				}
				$error = false;
				if($this->SppLearner->checkEmailExisted(trim($this->data['SppLearner']['email']))){
					$this->Session->setFlash(Configure::read('Message.EMAIL_EXISTED'));
					return;
				}
				$this->SppLearner->begin();
				$this->SppOrganization->begin();
				$this->SppOrganizationContent->begin();
				$this->SppLicense->begin();
				$this->SppLicenseContent->begin();
				if(!empty($learn_id)){
					$learner_classification_id = Configure::read('LEARNER_CLASSIFICATION.GENERAL');
					// insert new spp learner
					$this->SppLearner->set(array(
					'id' => $learn_id,
					'first_name' => $this->data['SppLearner']['first_name'],
					'last_name' => $this->data['SppLearner']['last_name'],
					'first_name_kana' => $this->data['SppLearner']['first_name_kana'],
					'last_name_kana' => $this->data['SppLearner']['last_name_kana'],
					'nickname' => $this->data['SppLearner']['nickname'],
					'email' => $this->data['SppLearner']['email'],
					'password' => $this->data['SppLearner']['password'],
					'organization_code' => $organization_code,
					'payment_status_id' => $payment_status,
					'learner_classification_id' => $learner_classification_id,
					'postal_code' => $postal_code,
					'zone' => $zone,
					'address' => $address,
					'address_detail' => $address_detail,
					'created_datetime' =>  date('Y-m-d H:i:s'),
					'updated_datetime' => date('Y-m-d H:i:s'),
					));
					if(!$this->SppLearner->save()){
						$error = true;
					}
					// increase registration_no to +1 for SppOrganization
					if(!$is_pesonal_code && !$error){
						$organization['SppOrganization']['registration_no'] += 1;
						if(!$this->SppOrganization->save($organization,array('conditions' => array('id'=>$organization['SppOrganization']['id'])))){
							$error = true;
						}
					}

					// generate spp_license
					if(!$error && $is_generate_license){
						$license_code = "";
						$temp_check = true;
						do{
							// generate license_code
							$license_code = $this->SppLicense->genRandomStringE();
							$temp_check = $this->SppLicense->checkLicenseCodeExit($license_code);
						} while($temp_check);
						$license_desc = $learn_id;
						if(!empty($this->data['SppLearner']['first_name'])){
							$license_desc = $license_desc." ".$this->data['SppLearner']['first_name'];
						}
						if(!empty($this->data['SppLearner']['last_name'])){
							$license_desc = $license_desc." ".$this->data['SppLearner']['last_name'];
						}
						$days_of_usage = $organization['SppOrganization']['days_of_usage'];
						$organization_date = $organization['SppOrganization']['organization_date'];
						$expired_start_date = date('Y-m-d');
						$expired_end_date = date('Y-m-d',strtotime("+".$days_of_usage." days"));
						if($organization_date != '0000-00-00'){
							$expired_end_date = $organization_date;
						}
						$this->SppLicense->set(array(
						'license_code' => $license_code,
						'license_desc' => $license_desc,
						'expired_start_date' => $expired_start_date,
						'expired_end_date' => $expired_end_date,
						'comment' => Configure::read('LICENSE.DEFAULT_COMMENT'),
						'learner_id' => $learn_id,
						'creator_id' => Configure::read('UserID.SYSADMIN'),
						'created_datetime' => date('Y-m-d H:i:s'),
						'updated_datetime' => date('Y-m-d H:i:s'),
						'user_id' => Configure::read('UserID.SYSADMIN'),
						'check_flag' => $organization['SppOrganization']['certificate']
						));
						if(!$this->SppLicense->save()){
							$error = true;
						}
					}

					// save license_content
					if(!$error && $is_generate_license){
						$organization_contents = $this->SppOrganizationContent->find('all',array('conditions' => array('organization_id' => $organization['SppOrganization']['id'])));
						if(!empty($organization_contents)){
							$license_id = $this->SppLicense->getLastInsertId();
							foreach ($organization_contents as $item){
								$this->SppLicenseContent->create();
								$this->SppLicenseContent->set(array(
											'license_id' => $license_id,
											'content_id' => $item['SppOrganizationContent']['content_id']));
								if(!$this->SppLicenseContent->save()){
									$error = true;
									break;
								}
							}
						}
					}
					if(!$error){
						$this->SppLearner->commit();
						$this->SppOrganization->commit();
						$this->SppLicense->commit();
						$this->SppLicenseContent->commit();
						// redirect to registration confirm screen
						if($payment_method_id == Configure::read('PAYMENT_METHOD.PERSONAL')){
							return $this->redirect(array('action' => 'registrationConfirm'));
						}
						if($payment_method_id == Configure::read('PAYMENT_METHOD.COMPANY')){
							return $this->redirect(array('action' => 'registrationHojinConfirm'));
						}
						$this->Session->setFlash(Configure::read('Message.INSERT_SUCCESS'));
						if(!$is_smart_device){
							return $this->redirect(array('action' => 'index'));
						}
					} else {
						$this->SppLearner->rollback();
						$this->SppOrganization->rollback();
						$this->SppLicense->rollback();
						$this->SppLicenseContent->rollback();
						$this->Session->setFlash(Configure::read('Message.INSERT_FAILURE'));
					}
				} else {
					// error message
					$this->Session->setFlash(Configure::read('Message.INSERT_FAILURE'));
					return;
				}
					
			}
		}catch(Exception $e){
			$this->SppLearner->rollback();
			$this->SppOrganization->rollback();
			$this->SppLicense->rollback();
			$this->SppLicenseContent->rollback();

			$this->Session->setFlash($e->getMessage());
		}
	}

	function csvImport(){
		if ($name = $this->_uploadfile()) {
			try{
				$aryFieldHeaders = array('last_name', 'first_name', 'last_name_kana', 'first_name_kana',
				 'email', 'postal_code', 'zone', 'address', 'address_detail', 'organization_code', 'password');
				$data = $this->Csv->import("files/" . $name, $aryFieldHeaders );
				unlink(WWW_ROOT . "files/" . $name);
			} catch (Exception $e){
				$this->Session->setFlash(Configure::read('Message.ERR_WRONG_FORMAT'));
				return $this->redirect(array('action' => 'index'));
			}
			if(!$data && is_bool($data) === true){
				$this->Session->setFlash(Configure::read('Message.ERR_WRONG_FORMAT'));
				return $this->redirect(array('action' => 'index'));
			}

			if(empty($data) ||  count($data) <= 1){
				$this->Session->setFlash(Configure::read('Message.ERR_HAVE_NO_DATA'));
				return $this->redirect(array('action' => 'index'));
			}
			$this->SppLearner->begin();
			try {
				unset($data[0]);
				$numberInsert = 0;
				$dataError = array();
				// validate all data before insert
				$error = false;
				foreach ($data as $item) {
					$result_validate = $this->validateLearner($item);
					if($result_validate !== true){
						$error = true;
						$item['SppLearner']['err_msg'] = $result_validate;
						array_push($dataError, $item);
					} else {
						$organization_code = $item['SppLearner']['organization_code'];
						$is_pesonal_code = $organization_code == Configure::read('PERSONAL_CODE');
						$learn_id = "";
						$is_generate_license = false;
						if(!$is_pesonal_code){
							$organization = $this->SppOrganization->find('first',array('conditions' => array('CONCAT(code_large,code_middle,code_small)'=>$organization_code)));
							$payment_method_id = $organization['SppOrganization']['payment_method_id'];
							$learn_id = $this->generalLearnerId($organization_code,$payment_method_id);
							$is_generate_license = $payment_method_id != Configure::read('PAYMENT_METHOD.STORE');
						} else {
							$learn_id = $this->generalLearnerId($organization_code,Configure::read('PAYMENT_METHOD.STORE'));
						}
						if(!empty($learn_id)){
							// insert new spp learner
							$this->SppLearner->create();
							$this->SppLearner->set(array(
							'id' => $learn_id,
							'first_name' => $item['SppLearner']['last_name'],
							'last_name' => $item['SppLearner']['first_name'],
							'first_name_kana' => $item['SppLearner']['last_name_kana'],
							'last_name_kana' => $item['SppLearner']['first_name_kana'],
							'email' => $item['SppLearner']['email'],
							'password' => $item['SppLearner']['password'],
							'organization_code' => $organization_code,
							'payment_status_id' => Configure::read('PAYMENT_STATUS.PAID'),
							'learner_classification_id' => Configure::read('LEARNER_CLASSIFICATION.GENERAL'),
							'postal_code' => $item['SppLearner']['postal_code'],
							'zone' => $item['SppLearner']['zone'],
							'address' => $item['SppLearner']['address'],
							'address_detail' => $item['SppLearner']['address_detail'],
							'created_datetime' =>  date('Y-m-d H:i:s'),
							'updated_datetime' => date('Y-m-d H:i:s'),
							));
							if(!$this->SppLearner->save()){
								$error = true;
							}
							// increase registration_no to +1 for SppOrganization
							if(!$is_pesonal_code){
								$organization['SppOrganization']['registration_no'] += 1;
								if(!$this->SppOrganization->save($organization,array('conditions' => array('id'=>$organization['SppOrganization']['id'])))){
									$error = true;
								}
							}
							// generate spp_license
							if(!$error && $is_generate_license){
								$license_code = "";
								do{
									// generate license_code
									$license_code = $this->SppLicense->genRandomStringE();
								} while($this->SppLicense->checkLicenseCodeExit($license_code));
								$license_desc = $learn_id;
								if(!empty($item['SppLearner']['first_name'])){
									$license_desc = $license_desc." ".$item['SppLearner']['first_name'];
								}
								if(!empty($item['SppLearner']['last_name'])){
									$license_desc = $license_desc." ".$item['SppLearner']['last_name'];
								}
								$days_of_usage = $organization['SppOrganization']['days_of_usage'];
								$organization_date = $organization['SppOrganization']['organization_date'];
								$expired_start_date = date('Y-m-d');
								$expired_end_date = date('Y-m-d',strtotime("+".$days_of_usage." days"));
								if($organization_date != '0000-00-00'){
									$expired_end_date = $organization_date;
								}
								$this->SppLicense->create();
								$this->SppLicense->set(array(
									'license_code' => $license_code,
									'license_desc' => $license_desc,
									'expired_start_date' => $expired_start_date,
									'expired_end_date' => $expired_end_date,
									'comment' => Configure::read('LICENSE.DEFAULT_COMMENT'),
									'learner_id' => $learn_id,
									'creator_id' => Configure::read('UserID.SYSADMIN'),
									'created_datetime' => date('Y-m-d H:i:s'),
									'updated_datetime' => date('Y-m-d H:i:s'),
									'user_id' => Configure::read('UserID.SYSADMIN'),
									'check_flag' => $organization['SppOrganization']['certificate']
								));
								if(!$this->SppLicense->save()){
									$error = true;
								}
							}

							// save license_content
							if(!$error && $is_generate_license){
								$organization_contents = $this->SppOrganizationContent->find('all',array('conditions' => array('organization_id' => $organization['SppOrganization']['id'])));
								if(!empty($organization_contents)){
									$license_id = $this->SppLicense->getLastInsertId();
									foreach ($organization_contents as $item_content){
										$this->SppLicenseContent->create();
										$this->SppLicenseContent->set(array(
											'license_id' => $license_id,
											'content_id' => $item_content['SppOrganizationContent']['content_id']));
										if(!$this->SppLicenseContent->save()){
											$error = true;
											break;
										}
									}
								}
							}
							$numberInsert++;
						}
					}
				}
				if(!$error){
					$this->SppLearner->commit();
					$this->Session->setFlash($numberInsert.Configure::read('Message.MSG_ROW_INSERT'));
				} else {
					$this->SppLearner->rollback();
					if(count($dataError) > 0){
						$this->set('dataError',$dataError);
						return;
					}
					$this->Session->setFlash(Configure::read('Message.ERR_IMPORT'));
				}
			} catch (Exception $e) {
				$this->SppLearner->rollback();
				$this->Session->setFlash(Configure::read('Message.ERR_IMPORT'));
			}
		} else {
			$this->Session->setFlash(Configure::read('Message.ERR_IMPORT'));
		}
		return $this->redirect(array('action' => 'index'));
	}

	/**
	 *
	 * upload file
	 */
	private function _uploadfile() {
		$name = time() . ".csv";
		$filename = "files/" . $name;
		/* copy uploaded file */
		if (move_uploaded_file($this->data['Pages']['file']['tmp_name'], $filename)) {
			return $name;
		} else {
			/* save message to session */
			echo 'There was a problem uploading file. Please try again.';
			return FALSE;
		}
	}

	/**
	 *
	 * validate learner data when import csv
	 * return: true if it's ok, otherwise return error message
	 */
	private function validateLearner($item){
		try{
			if(!empty($item)){
				$email = $item['SppLearner']['email'];
				if(empty($email)){
					return Configure::read('Message.ERR_MISSING_EMAIL');
				}

				if($this->SppLearner->checkEmailExisted($email)){
					return Configure::read('Message.ERR_EMAIL_EXISTED');
				}

				$organization_code = $item['SppLearner']['organization_code'];
				$is_pesonal_code = $organization_code == Configure::read('PERSONAL_CODE') ;
				if(!$is_pesonal_code){
					if(empty($organization_code)){
						return Configure::read('Message.ERR_MISSING_ORGANIZATION_CODE');
					}
					$organization = $this->SppOrganization->find('first',array('conditions'=>
					array('CONCAT(code_large,code_middle,code_small)' => $organization_code)));
					if(empty($organization)){
						return Configure::read('Message.ERR_ORGANIZATION_CODE_EXISTED');
					}
						
					if($organization['SppOrganization']['allowed_registration_no'] <= $organization['SppOrganization']['registration_no']){
						return Configure::read('Message.ERR_REGISTRATION_LEARNER_EXCEED');
					}
				}
				return true;
			} else {
				return 'NULL';
			}
		}catch (Exception $e){
			return $e->getMessage();
		}
	}

	function registrationConfirm(){
		$this->autoLayout = true;
		$is_smart_device = false;
		$iPhone = stripos($_SERVER['HTTP_USER_AGENT'],"iPhone");
		$Android = stripos($_SERVER['HTTP_USER_AGENT'],"Android");
		if($iPhone || $Android){
			$is_smart_device = true;
			$this->autoLayout = false;
		}
		if(!$is_smart_device){
			// check session and role
			if(!$this->isSystemManagement()){
				$this->render('/elements/error');
				return;
			}
		}
		$this->set ( 'is_smart_device', $is_smart_device );
	}

	function registrationHojinConfirm(){
		$this->autoLayout = true;
		$is_smart_device = false;
		$iPhone = stripos($_SERVER['HTTP_USER_AGENT'],"iPhone");
		$Android = stripos($_SERVER['HTTP_USER_AGENT'],"Android");
		if($iPhone || $Android){
			$is_smart_device = true;
			$this->autoLayout = false;
		}
		if(!$is_smart_device){
			// check session and role
			if(!$this->isSystemManagement()){
				$this->render('/elements/error');
				return;
			}
		}
		$this->set ( 'is_smart_device', $is_smart_device );
	}

	function getOrganizationName(){
		$this->autoLayout = false;
		$this->autoRender = false;
		$organization_code = $_POST['organization_code'];
		$organization = $this->SppOrganization->find('first',array('conditions' => array('CONCAT(code_large, code_middle, code_small)' => $organization_code)));
		if(!empty($organization)){
			return $organization['SppOrganization']['organization_name'];
		}
		return "";
	}
	function checkOrganizationExist($organization_code){
		$this->autoLayout = false;
		$this->autoRender = false;
		$this->loadModel("SppOrganization");
		$spp_organization = $this->SppOrganization->find('first',array('conditions' => array('CONCAT(code_large,code_middle,code_small)'=>trim($organization_code))));
		if(empty($spp_organization)){
			return 'false';
		}
		return 'true';
	}

	function generalLearnerId($organization_code,$payment_method_id){
		$max_learner = 0;
		$query = "SELECT MAX( CONVERT( RIGHT( id, 2 ) , UNSIGNED INTEGER ) )  as max_learner FROM spp_learners where organization_code = '".$organization_code."'";
		$result = mysql_query($query) or die(mysql_error());
		if($row = mysql_fetch_array($result)){
			$max_learner = $row['max_learner'];
		}
		do{
			$max_learner++;
			$formatted_value = sprintf("%04d", ($max_learner));
			$current_year = substr(date('Y',strtotime(date("y-m-d H:i:s").' -3 months')),-2); // get finacial year (just take 2 of the end)
			$learner_id_exited = $this->SppLearner->checkLearnerIdExisted($payment_method_id.$organization_code.$current_year.$formatted_value);
		}while($learner_id_exited);
			
		return $payment_method_id.$organization_code.$current_year.$formatted_value;
	}
}