import db from './db.js';

export default class SubCategory {

    findByParentCategory(categoryNo) {
        return db.transaction('r', db.sub_category, () => {
            return db.sub_category
                .where('category_no').equals(categoryNo)
                .and((sub_category) =>
                    (
                        sub_category.totalQuizOfSubCategory > 0
                    )
                );
        });
    }

    findBySubCategory (categoryNo, subCategoryNo) {
        return db.transaction('r', db.sub_category, () => {
            return db.sub_category
                .where('category_no').equals(categoryNo)
                .and((subCategory) => {
                    return subCategory.subcategory_no == subCategoryNo
                });
        });
    }
}