import db       from "./db";
const $             = require('jquery');
import config from "./config";
import Login        from './login.js';
/**
 * shared funct
 *
 * @updated 23.12.2018
 * @author ChienNguyen
 */


/**
 * funct random array
 *
 * return random
 */

export function randomArray(arrays) {
    return arrays[Math.floor(Math.random()*arrays.length)];
}

/**
 * funct auto clear cache 
 *
 */

export function autoClearCache(){
    var cookie = document.cookie.split(';');
    var myItem = localStorage.getItem('message_list');

    localStorage.clear();
    localStorage.setItem("message_list", myItem);
    for (var i = 0; i < cookie.length; i++) {
        var chip = cookie[i],
        entry = chip.split("="),
        name = entry[0];
        document.cookie = name+" =; expires = Thu, 01 Jan 1970 00:00:00 UTC";
    }
}


/**
 * funct random Object
 *
 * return random
 */

export function randomObject(objects) {
    return objects[Object.keys(objects)[Math.floor(Math.random()*Object.keys(objects).length)]];
}

/**
	 * create list quiz random for cate
	 *
	 * @param 
	 * @return list array quiz 
	 * @updated 21.12.2018
	 */

export function createListQuizIncorrectRandom (listQuizIncorrectSortedByCate = array()) {
        var listCateQuizRandom = [];
        if(listQuizIncorrectSortedByCate.length)
        {
        	var page = 1;
        	listQuizIncorrectSortedByCate.forEach(function(data,key){
		        for (var i = data.list_quiz.length-1; i >=0; i--) {
			            var randomIndex = Math.floor(Math.random()*(i+1));
			            var itemAtIndex = data.list_quiz[randomIndex];
			            data.list_quiz[randomIndex] = data.list_quiz[i];
			            data.list_quiz[i] = itemAtIndex;
			    }
			    
			    var count_quiz = data.list_quiz.length;
			    for (var i = 0; i < count_quiz; i++) {
			    	var quiz = data.list_quiz[i];
			        var tmpData = {
			        	'id'			 : page,
			        	'category_no'	 : quiz.category_no,
			        	'subcategory_no' : quiz.subcategory_no,
			        	'quiz_no' 		 : quiz.quiz_no,
			        };
			        listCateQuizRandom.push(tmpData);
			        page++;
			    }
		    });  
        }
       return listCateQuizRandom;
}

/**
* check json string
*
* @updated 2019.01.22
*/

export function IsJsonString(str) {
    try {
        JSON.parse(str);
    } catch (e) {
        return false;
    }
    return true;
}


/**
* 
*
* @updated 2019.01.22
*/

export function returnListBigCategory(arrayCategory) {
	var listBigCate = [];
	var tmpCheckBigCate = [];
	try {
    	for(var i = 0; i < arrayCategory.length; i++) {
    		if (tmpCheckBigCate.indexOf(arrayCategory[i].category_notation) === -1) {
        		listBigCate.push(arrayCategory[i]);
        		tmpCheckBigCate.push(arrayCategory[i].category_notation);
        	}
        }
    } catch (e) {
    	console.log(e);
    }
    return listBigCate;
}

/*
* custom content quiz case fill blank
*
* 
 */

export function customContentQuizForAnswer()
{
	// custom html && class 
	$("span").each(function() {
		if($(this).html() && !$(this).hasClass('show_answer_fill_blank') && $(this).html().indexOf('(') != -1)
		{
			let data_fill = $(this).html().trim().substring(0, 1);
			$(this).addClass('fill_blank').attr('data-fill', data_fill);
		}
	});
}

export function customContentQuiz(quiz)
{
	var expand_phrase = false;
console.log("customContentQuiz1");
//console.log("quiz:"+quiz);
console.log(quiz.choices);
console.log(quiz.choices[0].answer);
	if(quiz && quiz.choices && quiz.choices[0].answer.indexOf('|') != -1)
	{
		expand_phrase = true;
	}
console.log("expand_phrase:"+expand_phrase);

	// custom html && class 
	var tmpFill = [];
	var dataSelects = [];
	$("#sec1 span").each(function() {
		if($(this).html() && !$(this).hasClass('show_answer_fill_blank'))
		{
			let data_fill = $(this).html().trim().substring(0, 1);
			if (tmpFill.indexOf(data_fill) === -1) {
				tmpFill.push(data_fill);
			}
		}
	});
	tmpFill.sort();

console.log("customContentQuiz2");

	//
	if(expand_phrase == true)
	{

		for (var i = 0; i < tmpFill.length; i++) {
			var value = '';
			if(quiz.choices[i]){
				var expand_choice = quiz.choices[i].answer.split('|');
				for (var j = 0; j < expand_choice.length; j++) {
					let answer = expand_choice[j];
					let convert_number_to_symbol = '（' + (j + 1) + '）';
					if(config.NUMBER_SYMBOL[j]){
						convert_number_to_symbol = config.NUMBER_SYMBOL[j];
					}
					
					value += '<option value="'+ (j + 1) +'" data-text="'+ answer +'">'+ convert_number_to_symbol +''+ answer +'</option>';
				}
			}
			dataSelects[tmpFill[i]] = value;
		}
	}
	else{
		var value = '';
console.log("quiz.choices.length:"+quiz.choices.length);
		for (var j = 0; j < quiz.choices.length; j++) {
			let tmpChoices = quiz.choices[j];
			let convert_number_to_symbol = '（' + tmpChoices.choice_no + '）';
			if(config.NUMBER_SYMBOL[tmpChoices.choice_no - 1]){
				convert_number_to_symbol = config.NUMBER_SYMBOL[tmpChoices.choice_no - 1];
			}
			value += '<option value="'+ tmpChoices.choice_no +'" data-text="'+ tmpChoices.answer +'">'+ convert_number_to_symbol +''+ tmpChoices.answer +'</option>';
		}
		for (var i = 0; i < tmpFill.length; i++) {
			dataSelects[tmpFill[i]] = value;
		}
	}
	
console.log("customContentQuiz3");
	$("#sec1 span").each(function() {
		if($(this).html() && !$(this).hasClass('show_answer_fill_blank'))
		{
			let data_fill = $(this).html().trim().substring(0, 1);
			let data_select = '';
			if(dataSelects[data_fill]){
				data_select = dataSelects[data_fill];
			}
			$(this).addClass('fill_blank').attr('data-fill', data_fill).attr('data-option', data_select);
		}
	});

	//  add event handle fill blank
	handleFillBlank();
	selectChoice();
}

// Ҽ
export function customContentQuiz2(quiz)
{
	var expand_phrase = false;
console.log("customContentQuiz2-1");
console.log(quiz.choices);
console.log(quiz.choices[0].answer);
	if(quiz && quiz.choices && quiz.choices[0].answer.indexOf('|') != -1)
	{
		expand_phrase = true;
	}
console.log("expand_phrase:"+expand_phrase);

	// custom html && class 
	var tmpFill = [];
	var dataSelects = [];
	$("#sec1 span").each(function() {
		if($(this).html() && !$(this).hasClass('show_answer_fill_blank'))
		{
			let data_fill = $(this).html().trim().substring(0, 1);
			if (tmpFill.indexOf(data_fill) === -1) {
				tmpFill.push(data_fill);
			}
		}
	});
	tmpFill.sort();

console.log("customContentQuiz2-2");

	//
	if(expand_phrase == true)
	{

		for (var i = 0; i < tmpFill.length; i++) {
			var value = '';
			if(quiz.choices[i]){
				var expand_choice = quiz.choices[i].answer.split('|');
				for (var j = 0; j < expand_choice.length; j++) {
					let answer = expand_choice[j];
					let convert_number_to_symbol = '（' + (j + 1) + '）';
					if(config.NUMBER_SYMBOL[j]){
						convert_number_to_symbol = config.NUMBER_SYMBOL[j];
					}
					
					value += '<option value="'+ (j + 1) +'" data-text="'+ answer +'">'+ convert_number_to_symbol +''+ answer +'</option>';
				}
			}
console.log("customContentQuiz2-2-1:"+value);
			dataSelects[tmpFill[i]] = value;
		}
	}
	else{
		var value = '';
console.log("quiz.choices.length:"+quiz.choices.length);
		for (var j = 0; j < quiz.choices.length; j++) {
			let tmpChoices = quiz.choices[j];
			let convert_number_to_symbol = '（' + tmpChoices.choice_no + '）';
			if(config.NUMBER_SYMBOL[tmpChoices.choice_no - 1]){
				convert_number_to_symbol = config.NUMBER_SYMBOL[tmpChoices.choice_no - 1];
			}
			value += '<option value="'+ tmpChoices.choice_no +'" data-text="'+ tmpChoices.answer +'">'+ convert_number_to_symbol +''+ tmpChoices.answer +'</option>';
console.log("customContentQuiz2-2-2:"+value);
		}
		for (var i = 0; i < tmpFill.length; i++) {
			dataSelects[tmpFill[i]] = value;
		}
	}
	
console.log("customContentQuiz2-3");
	$("#sec1 span").each(function() {
		if($(this).html() && !$(this).hasClass('show_answer_fill_blank'))
		{
			let data_fill = $(this).html().trim().substring(0, 1);
			let data_select = '';
			if(dataSelects[data_fill]){
				data_select = dataSelects[data_fill];
			}
/*
			$(this).addClass('fill_blank2').attr('data-fill', data_fill).attr('data-option', data_select);
*/
/*
			$(this).addClass('desc_blank').attr('data-fill', data_fill).attr('data-option', data_select);
*/
			//$(this).addClass('desc_blank').attr('data-desc', "data_desc");
		}
	});

	$("#sec1 input").each(function() {
		//if($(this).html() && !$(this).hasClass('show_answer_fill_blank'))
		//{
console.log("customContentQuiz2-3-1");
			$(this).addClass('desc_blank').attr('data-desc', "data_desc");
		//}
	});

	//  add event handle fill blank
	handleFillBlank();
	// selectChoice();
}

export function handleFillBlank()
{
	$('.fill_blank').click(function(e){
		e.preventDefault();
		//  handle & open modal select choice
		var data_fill = $(this).attr('data-fill');
		var data_option = $(this).attr('data-option');
		let data_select  = null;
		if($(this).attr('data-select'))
		{
			data_select = $(this).attr('data-select');
		}
		// 
		$("#selectChoice").html(data_option);

		$("#selectChoice").val(data_select);
		$("#dataFill").html(data_fill);

		$('[data-popup="popup-list-choice"]').fadeIn(100);
		$('[data-popup-close="popup-fill-blank"]').click(function (e) {
            $('[data-popup="popup-list-choice"]').fadeOut(100);
            e.preventDefault();
        });

		$("#selectChoice").attr('data-fill', data_fill);
	});
}

export function selectChoice()
{
	$("#selectChoice").change(function (e) {
		e.preventDefault();
		var selectChoice = $("#selectChoice > option:selected").attr("value");
		var data_fill = $("#selectChoice").attr("data-fill");
		var text = $( "#selectChoice option:selected" ).attr('data-text');
			// 
		$('[data-fill="'+ data_fill +'"]').attr('data-select', selectChoice);
		$('[data-fill="'+ data_fill +'"] span').html(text).addClass('fill_blank_select');

		checkBeforeSubmitAnswer();
		
	});
}

export function checkBeforeSubmitAnswer()
{
	var is_check_enable_button_answer = true;
	var userChoices = [];
	var tmpChoices = [];
	var tmpFill = [];
	$('[data-fill]').each(function() {
		if(!$(this).attr('data-select'))
		{
			is_check_enable_button_answer = false;
		}
		if (tmpFill.indexOf($(this).attr('data-fill')) === -1) {
			tmpFill.push($(this).attr('data-fill'));
			var tmp = {
					data_fill 	: $(this).attr('data-fill'),
					value		: $(this).attr('data-select')
			};
			tmpChoices.push(tmp);
		}
	});
	if(is_check_enable_button_answer == true)
	{
		$('#divFillBlank .button_disable').attr('style', 'display:none');
		$('#divFillBlank .button_enable').attr('style', 'display:inline');
	}else
	{
		$('#divFillBlank .button_disable').attr('style', 'display:inline');
		$('#divFillBlank .button_enable').attr('style', 'display:none');
	}
	tmpChoices.sort(function(a,b) {
		return b.data_fill - a.data_fill;
	});

	for (var i = 0;i < tmpChoices.length; i++) {
		userChoices.push(tmpChoices[i].value);
	}
	return userChoices;
}

export function checkBeforeSubmitAnswer2()
{
	var is_check_enable_button_answer = true;
	var userChoices = [];
	var tmpChoices = [];
	var tmpFill = [];
	$('[data-fill]').each(function() {
		if(!$(this).attr('data-select'))
		{
			is_check_enable_button_answer = false;
		}
		if (tmpFill.indexOf($(this).attr('data-fill')) === -1) {
			tmpFill.push($(this).attr('data-fill'));
			var tmp = {
					data_fill 	: $(this).attr('data-fill'),
					value		: $(this).attr('data-select')
			};
			tmpChoices.push(tmp);
		}
	});
	if(is_check_enable_button_answer == true)
	{
		$('#divFillBlank .button_disable').attr('style', 'display:none');
		$('#divFillBlank .button_enable').attr('style', 'display:inline');
	}else
	{
		$('#divFillBlank .button_disable').attr('style', 'display:inline');
		$('#divFillBlank .button_enable').attr('style', 'display:none');
	}
	tmpChoices.sort(function(a,b) {
		return b.data_fill - a.data_fill;
	});

	for (var i = 0;i < tmpChoices.length; i++) {
		userChoices.push(tmpChoices[i].value);
	}
	return userChoices;
}

export function getListFillBlank()
{
	var listFill = [];
	$('[data-fill]').each(function() {
		if (listFill.indexOf($(this).attr('data-fill')) === -1) {
			listFill.push($(this).attr('data-fill'));
		}
	});
	return listFill;
}

/**
* function handle set face mark
*
* @updated 07.01.2019
*/
export function functHandleSetFaceMark () {
	$('.handle_face_mark').click(function(e){
		e.preventDefault();
		// show popup
		var that = this;
		var id = $(that).attr('id');
		var id_choice = $(that).attr('data-id');
		var id_quiz = $(that).attr('data-quiz-id');
	    $(that).find('.popuptext').show();
	    var idPopup = "myPopup" + id;

	    $(".handle_face_mark .popuptext").each(function() {
		    if($(this).prop('id') != idPopup.toString())
		    {	
		    	$(this).removeClass('show');
		    }
		});
	    
	    var popup = document.getElementById(idPopup);
	    popup.classList.toggle("show");

	    // handle 
	    $("#" + id + ' .face-mark').click(function(e){
	  		e.preventDefault();
		  	var src = $(this).attr('data-src');

		  	var check_remove = false;
		  	if($("#" + id).find('.btn_icon p img').length)
		  	{
		  		let current_src = $("#" + id).find('.btn_icon p img').attr('src');
		  		if(current_src.indexOf(src) != -1)
		  		{
		  			check_remove = true;
		  		}
		  	}

		  	if(check_remove == true)
		  	{
		  		$("#" + id).find('.btn_icon p img').remove();
		  		if($(that).hasClass("is_set_face_mark"))
				{
				  	$(that).removeClass("is_set_face_mark");
				}
		  	}
		  	else
		  	{
		  		if(!$(that).hasClass("is_set_face_mark"))
				{
				    $(that).addClass("is_set_face_mark");
				}
				$("#" + id).find('.btn_icon p').html('<img src="'+ config.subfolder +'/'+ src +'" width="26" alt="">');
		  	}

		    // update record

		    db.transaction('rw', db.record, db.quizzes, () => {
		    let recordInfo = db.record
                .where('id').equals(id_quiz) 
                .first();
            recordInfo.then(function(record) 
                {	
                	var loginObj = new Login();
                	if(record)
                	{
                		let face_marks = {};
                		if(record.face_marks && IsJsonString(record.face_marks))
                		{
                			face_marks = JSON.parse(record.face_marks);
                		}
                		face_marks[id_choice] = src;

                		if(check_remove == true)
	            		{
	            			delete face_marks[id_choice];
	            		}

                		record.is_modify = 1;
                		record.face_marks = JSON.stringify(face_marks);
                		
	                	db.record.put(record).catch('Data Limit', err => {
	                        console.log("--- Update Faild ---")
	                    });
                	}
                	else
                	{
                		let quizInfo = db.quizzes
			                .where('id').equals(id_quiz) 
			                .first();
			            quizInfo.then(function(quiz) 
                		{
                			if(quiz)
                			{
                				// 
                				let array_key = [quiz.category_no, quiz.subcategory_no, quiz.quiz_no];
	            				let primary_key = array_key.toString();
	            				let face_marks = {};
	            				if(check_remove != true)
	            				{
	            					face_marks[id_choice] = src;
	            				}
	            				
	                			let recordStore = {
					                'id' : primary_key,
					                'category_no': quiz.category_no, 
					                'subcategory_no': quiz.subcategory_no, 
					                'quiz_no': quiz.quiz_no,
					                'try_count': 0,
					                'incorrect_count': 0,
					                'last_answered': 0,
					                'last_incorrect_count': 0,
					                'selectbox': false,
					                'content_id': quiz.content_id,
					                'client_id': '', 
					                'face_marks': JSON.stringify(face_marks),
					                'learner_id': loginObj.isLogged(),
					                'is_modify': 1
					            };
					            db.record.put(recordStore);
                			}
                		});
                	}
                });
	        });
		});
	});
}

/**
* function md5
*
* @updated 2019.05.20
*/

export function md5(d){return rstr2hex(binl2rstr(binl_md5(rstr2binl(d),8*d.length)))}function rstr2hex(d){for(var _,m="0123456789ABCDEF",f="",r=0;r<d.length;r++)_=d.charCodeAt(r),f+=m.charAt(_>>>4&15)+m.charAt(15&_);return f}function rstr2binl(d){for(var _=Array(d.length>>2),m=0;m<_.length;m++)_[m]=0;for(m=0;m<8*d.length;m+=8)_[m>>5]|=(255&d.charCodeAt(m/8))<<m%32;return _}function binl2rstr(d){for(var _="",m=0;m<32*d.length;m+=8)_+=String.fromCharCode(d[m>>5]>>>m%32&255);return _}function binl_md5(d,_){d[_>>5]|=128<<_%32,d[14+(_+64>>>9<<4)]=_;for(var m=1732584193,f=-271733879,r=-1732584194,i=271733878,n=0;n<d.length;n+=16){var h=m,t=f,g=r,e=i;f=md5_ii(f=md5_ii(f=md5_ii(f=md5_ii(f=md5_hh(f=md5_hh(f=md5_hh(f=md5_hh(f=md5_gg(f=md5_gg(f=md5_gg(f=md5_gg(f=md5_ff(f=md5_ff(f=md5_ff(f=md5_ff(f,r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+0],7,-680876936),f,r,d[n+1],12,-389564586),m,f,d[n+2],17,606105819),i,m,d[n+3],22,-1044525330),r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+4],7,-176418897),f,r,d[n+5],12,1200080426),m,f,d[n+6],17,-1473231341),i,m,d[n+7],22,-45705983),r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+8],7,1770035416),f,r,d[n+9],12,-1958414417),m,f,d[n+10],17,-42063),i,m,d[n+11],22,-1990404162),r=md5_ff(r,i=md5_ff(i,m=md5_ff(m,f,r,i,d[n+12],7,1804603682),f,r,d[n+13],12,-40341101),m,f,d[n+14],17,-1502002290),i,m,d[n+15],22,1236535329),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+1],5,-165796510),f,r,d[n+6],9,-1069501632),m,f,d[n+11],14,643717713),i,m,d[n+0],20,-373897302),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+5],5,-701558691),f,r,d[n+10],9,38016083),m,f,d[n+15],14,-660478335),i,m,d[n+4],20,-405537848),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+9],5,568446438),f,r,d[n+14],9,-1019803690),m,f,d[n+3],14,-187363961),i,m,d[n+8],20,1163531501),r=md5_gg(r,i=md5_gg(i,m=md5_gg(m,f,r,i,d[n+13],5,-1444681467),f,r,d[n+2],9,-51403784),m,f,d[n+7],14,1735328473),i,m,d[n+12],20,-1926607734),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+5],4,-378558),f,r,d[n+8],11,-2022574463),m,f,d[n+11],16,1839030562),i,m,d[n+14],23,-35309556),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+1],4,-1530992060),f,r,d[n+4],11,1272893353),m,f,d[n+7],16,-155497632),i,m,d[n+10],23,-1094730640),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+13],4,681279174),f,r,d[n+0],11,-358537222),m,f,d[n+3],16,-722521979),i,m,d[n+6],23,76029189),r=md5_hh(r,i=md5_hh(i,m=md5_hh(m,f,r,i,d[n+9],4,-640364487),f,r,d[n+12],11,-421815835),m,f,d[n+15],16,530742520),i,m,d[n+2],23,-995338651),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+0],6,-198630844),f,r,d[n+7],10,1126891415),m,f,d[n+14],15,-1416354905),i,m,d[n+5],21,-57434055),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+12],6,1700485571),f,r,d[n+3],10,-1894986606),m,f,d[n+10],15,-1051523),i,m,d[n+1],21,-2054922799),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+8],6,1873313359),f,r,d[n+15],10,-30611744),m,f,d[n+6],15,-1560198380),i,m,d[n+13],21,1309151649),r=md5_ii(r,i=md5_ii(i,m=md5_ii(m,f,r,i,d[n+4],6,-145523070),f,r,d[n+11],10,-1120210379),m,f,d[n+2],15,718787259),i,m,d[n+9],21,-343485551),m=safe_add(m,h),f=safe_add(f,t),r=safe_add(r,g),i=safe_add(i,e)}return Array(m,f,r,i)}function md5_cmn(d,_,m,f,r,i){return safe_add(bit_rol(safe_add(safe_add(_,d),safe_add(f,i)),r),m)}function md5_ff(d,_,m,f,r,i,n){return md5_cmn(_&m|~_&f,d,_,r,i,n)}function md5_gg(d,_,m,f,r,i,n){return md5_cmn(_&f|m&~f,d,_,r,i,n)}function md5_hh(d,_,m,f,r,i,n){return md5_cmn(_^m^f,d,_,r,i,n)}function md5_ii(d,_,m,f,r,i,n){return md5_cmn(m^(_|~f),d,_,r,i,n)}function safe_add(d,_){var m=(65535&d)+(65535&_);return(d>>16)+(_>>16)+(m>>16)<<16|65535&m}function bit_rol(d,_){return d<<_|d>>>32-_}


/**
* function md5
*
* @updated 2019.05.20
*/

export function handleUseClassCode(class_code){
	$( "#sec1 li" ).each(function( index ) {
	  	if(!$( this ).hasClass(class_code)){
	  		$( this ).remove();
	  	}
	});
}

