import db from './db.js';

export default class Message {
    getMessagesList() {
        return db.transaction('r', db.message, async () => {
            let messages = await db.message.toArray();
            if (messages.length > 0) {
                messages.sort(function(a,b){
                    let tmp_a  = new Date(a.delivery_date);
                    let tmp_b  = new Date(b.delivery_date);
                    return tmp_a < tmp_b ? -1 : tmp_a < tmp_b ? 1 : 0;
                });
                return messages.reverse();
            } else {
                return null;
            }
        });
    }
    getMessagesOne(id) {        
        return db.transaction('r', db.message, () => {
            return db.message
                .where('id').equals(String(id)).first();
        });
    }

}
